<?php
require_once __DIR__ . '/../lib/bootstrap.php';

$u = current_user();
if (!$u) {
  header('Location: ' . base_url('auth/login.php'));
  exit;
}

$pdo = db();

// Detect password column name
function col_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
  $st->execute([$col]);
  return (bool)$st->fetchColumn();
}
$passCol = col_exists($pdo,'users','password_hash') ? 'password_hash' : (col_exists($pdo,'users','password') ? 'password' : null);
if (!$passCol) {
  $page_title = "Change Password";
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-danger shadow-sm">Cannot find password column in <code>users</code>. Expected <code>password_hash</code> or <code>password</code>.</div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $current = (string)($_POST['current_password'] ?? '');
  $new1 = (string)($_POST['new_password'] ?? '');
  $new2 = (string)($_POST['confirm_password'] ?? '');

  if (strlen($new1) < 8) {
    flash_set('danger', 'New password must be at least 8 characters.');
  } elseif ($new1 !== $new2) {
    flash_set('danger', 'New password and confirmation do not match.');
  } else {
    $st = $pdo->prepare("SELECT id, `$passCol` AS pw FROM users WHERE id=?");
    $st->execute([(int)$u['id']]);
    $row = $st->fetch();
    if (!$row) {
      flash_set('danger', 'User not found.');
    } else {
      $stored = (string)$row['pw'];
      $ok = false;

      if ($passCol === 'password_hash') {
        $ok = password_verify($current, $stored);
      } else {
        // Legacy: may be plain or hashed. Try verify first, then fallback to plain compare.
        $ok = password_verify($current, $stored) || hash_equals($stored, $current);
      }

      if (!$ok) {
        flash_set('danger', 'Current password is incorrect.');
      } else {
        $newHash = password_hash($new1, PASSWORD_DEFAULT);
        $upd = $pdo->prepare("UPDATE users SET `$passCol`=?, updated_at=NOW() WHERE id=?");
        $upd->execute([$newHash, (int)$u['id']]);
        flash_set('success', 'Password updated successfully.');
        header('Location: ' . base_url('account/change_password.php'));
        exit;
      }
    }
  }
}

$page_title = "Change Password";
include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Change Password</h3>
    <div class="text-muted">Update your own password securely.</div>
  </div>
</div>

<div class="card shadow-sm" style="max-width: 640px;">
  <div class="card-body">
    <form method="post" autocomplete="off">
      <div class="mb-3">
        <label class="form-label">Current password</label>
        <input type="password" name="current_password" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">New password</label>
        <input type="password" name="new_password" class="form-control" minlength="8" required>
        <div class="form-text">Minimum 8 characters.</div>
      </div>

      <div class="mb-3">
        <label class="form-label">Confirm new password</label>
        <input type="password" name="confirm_password" class="form-control" minlength="8" required>
      </div>

      <button class="btn btn-primary"><i class="bi bi-check2-circle me-1"></i>Update Password</button>
      <a class="btn btn-outline-secondary" href="<?=h(base_url('index.php'))?>">Cancel</a>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
