<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);

$full = trim($_POST['full_name'] ?? '');
$email = trim($_POST['email'] ?? '');
$role = $_POST['role'] ?? 'REQUESTER';
$pw = $_POST['password'] ?? '';
$isActive = (int)($_POST['is_active'] ?? 1);

if ($full === '' || $email === '' || $pw === '') {
  flash_set('danger', 'Name, email, and password are required.');
  header('Location: ' . base_url('admin/users.php'));
  exit;
}
if (!in_array($role, ['REQUESTER','STOREKEEPER','ADMIN'], true)) $role = 'REQUESTER';

try {
  $hash = password_hash($pw, PASSWORD_DEFAULT);
  db()->prepare("INSERT INTO users(full_name,email,password_hash,role,is_active) VALUES(?,?,?,?,?)")
      ->execute([$full,$email,$hash,$role,$isActive]);
  flash_set('success', 'User created.');
} catch (Throwable $e) {
  flash_set('danger', 'Error: ' . $e->getMessage());
}
header('Location: ' . base_url('admin/users.php'));
exit;
