<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN']);

$pdo = db();

try {
  $pdo->query("SELECT 1 FROM activity_log LIMIT 1");
} catch (Throwable $e) {
  $page_title = "Activity Logs";
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-warning">
          <strong>Activity log table is missing.</strong><br>
          Please run the SQL to create <code>activity_log</code> table.
        </div>
        <div class="card shadow-sm mt-3">
          <div class="card-body">
            <div class="text-muted">
              Note: Logs appear when the system calls <code>log_activity()</code> (available in <code>lib/bootstrap.php</code>).
            </div>
          </div>
        </div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

function q($k,$d=''){ return $_GET[$k] ?? $d; }
$search = trim((string)q('search',''));
$action = trim((string)q('action',''));
$page = max(1,(int)q('page',1));
$per_page = (int)q('per_page',25);
if (!in_array($per_page,[10,25,50,100], true)) $per_page = 25;
$offset = ($page-1)*$per_page;

$where = [];
$params = [];

if ($search !== '') {
  $where[] = "(u.full_name LIKE ? OR al.action LIKE ? OR al.entity LIKE ? OR al.ip_address LIKE ? OR al.details LIKE ?)";
  $like = "%{$search}%";
  $params += [$like,$like,$like,$like,$like];
}
if ($action !== '') {
  $where[] = "al.action = ?";
  $params[] = $action;
}
$whereSql = $where ? ('WHERE '.implode(' AND ', $where)) : '';

$actions = $pdo->query("SELECT DISTINCT action FROM activity_log ORDER BY action")->fetchAll();

$count = $pdo->prepare("
  SELECT COUNT(*)
  FROM activity_log al
  LEFT JOIN users u ON u.id = al.user_id
  $whereSql
");
$count->execute($params);
$total = (int)$count->fetchColumn();
$total_pages = max(1, (int)ceil($total/$per_page));
if ($page > $total_pages) { $page = $total_pages; $offset = ($page-1)*$per_page; }

$st = $pdo->prepare("
  SELECT al.*, u.full_name
  FROM activity_log al
  LEFT JOIN users u ON u.id = al.user_id
  $whereSql
  ORDER BY al.id DESC
  LIMIT $per_page OFFSET $offset
");
$st->execute($params);
$rows = $st->fetchAll();

function qs_keep(array $overrides=[]): string {
  $b = $_GET;
  foreach($overrides as $k=>$v){ $b[$k]=$v; }
  return http_build_query($b);
}

$page_title = "Activity Logs";
include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h3 class="mb-0">Activity Logs</h3>
    <div class="text-muted small">Total: <?=h((string)$total)?> records</div>
  </div>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-6">
        <label class="form-label">Search</label>
        <input class="form-control" name="search" value="<?=h($search)?>" placeholder="User, action, entity, IP, details...">
      </div>
      <div class="col-md-2">
        <label class="form-label">Action</label>
        <select class="form-select" name="action">
          <option value="">All</option>
          <?php foreach($actions as $a): $av=(string)$a['action']; ?>
            <option value="<?=h($av)?>" <?=($action===$av?'selected':'')?>><?=h($av)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Rows</label>
        <select class="form-select" name="per_page">
          <?php foreach([10,25,50,100] as $n): ?>
            <option value="<?=h((string)$n)?>" <?=($per_page===$n?'selected':'')?>><?=h((string)$n)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <button class="btn btn-primary w-100"><i class="bi bi-search me-1"></i>Apply</button>
      </div>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="card-header d-flex justify-content-between align-items-center">
    <div class="text-muted small">Page <?=h((string)$page)?> / <?=h((string)$total_pages)?></div>
    <nav>
      <ul class="pagination pagination-sm mb-0">
        <li class="page-item <?=($page<=1?'disabled':'')?>">
          <a class="page-link" href="?<?=h(qs_keep(['page'=>max(1,$page-1)]))?>">Prev</a>
        </li>
        <li class="page-item disabled"><span class="page-link"><?=h((string)$page)?></span></li>
        <li class="page-item <?=($page>=$total_pages?'disabled':'')?>">
          <a class="page-link" href="?<?=h(qs_keep(['page'=>min($total_pages,$page+1)]))?>">Next</a>
        </li>
      </ul>
    </nav>
  </div>

  <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th style="width:90px;">#</th>
          <th>User</th>
          <th style="width:170px;">Action</th>
          <th>Entity</th>
          <th style="width:140px;">IP</th>
          <th>Details</th>
          <th style="width:190px;">Time</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$rows): ?>
          <tr><td colspan="7" class="p-4 text-center text-muted">No logs found.</td></tr>
        <?php endif; ?>
        <?php foreach($rows as $r): ?>
          <tr>
            <td class="text-muted">#<?=h((string)(int)$r['id'])?></td>
            <td class="fw-semibold"><?=h((string)($r['full_name'] ?? '-'))?></td>
            <td><span class="badge bg-secondary"><?=h((string)$r['action'])?></span></td>
            <td class="text-muted">
              <?=h((string)($r['entity'] ?? ''))?>
              <?php if (!empty($r['entity_id'])): ?>
                <span class="text-muted">#<?=h((string)$r['entity_id'])?></span>
              <?php endif; ?>
            </td>
            <td class="text-muted"><?=h((string)($r['ip_address'] ?? ''))?></td>
            <td class="text-muted small"><?=h((string)($r['details'] ?? ''))?></td>
            <td class="text-muted small"><?=h((string)$r['created_at'])?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
