<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN','STOREKEEPER']);

$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?");
  $st->execute([$name]);
  return (bool)$st->fetchColumn();
}

if (!table_exists($pdo, 'categories')) {
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-warning"><strong>Missing table:</strong> categories.<br>'
     . 'Create it first, then refresh.</div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  if ($name === '') {
    flash_set('danger', 'Please enter a category name.');
  } else {
    $chk = $pdo->prepare("SELECT id FROM categories WHERE LOWER(name)=LOWER(?) LIMIT 1");
    $chk->execute([$name]);
    if ($chk->fetchColumn()) {
      flash_set('danger', 'This category already exists.');
    } else {
      $pdo->prepare("INSERT INTO categories(name) VALUES(?)")->execute([$name]);
      flash_set('success', '✅ Category added successfully.');
    }
  }
  header('Location: ' . base_url('admin/categories.php'));
  exit;
}

$cats = $pdo->query("SELECT id, name, created_at FROM categories ORDER BY name")->fetchAll();

include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h3 class="mb-1">Categories</h3>
    <div class="text-muted">Used for organizing items</div>
  </div>
  <a class="btn btn-outline-secondary" href="<?=h(base_url('admin/items.php'))?>">Back to Items</a>
</div>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h5 class="mb-3">Add Category</h5>
    <form method="post" class="row g-2">
      <div class="col-md-6">
        <input class="form-control" name="name" placeholder="e.g. Stationery" required>
      </div>
      <div class="col-md-2">
        <button class="btn btn-success w-100">Add</button>
      </div>
    </form>
    <div class="form-text mt-2">Tip: Keep category names short and clear.</div>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <table class="table table-hover mb-0">
      <thead class="table-light">
        <tr><th>Name</th><th style="width:220px;">Created</th></tr>
      </thead>
      <tbody>
        <?php if (!$cats): ?>
          <tr><td colspan="2" class="p-4 text-center text-muted">No categories yet.</td></tr>
        <?php endif; ?>
        <?php foreach ($cats as $c): ?>
          <tr>
            <td class="fw-semibold"><?=h($c['name'])?></td>
            <td class="text-muted"><?=h($c['created_at'])?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
