<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN']);

$pdo = db();

// Safe check: table exists?
try {
  $pdo->query("SELECT 1 FROM login_audit LIMIT 1");
} catch (Throwable $e) {
  $page_title = "Login Logs";
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-warning">
          <strong>Login logs table is missing.</strong><br>
          Please run the SQL to create <code>login_audit</code> table.
        </div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

function q($k,$d=''){ return $_GET[$k] ?? $d; }

$search = trim((string)q('search',''));
$success = (string)q('success','');
$page = max(1,(int)q('page',1));
$per_page = (int)q('per_page',25);
if (!in_array($per_page,[10,25,50,100], true)) $per_page = 25;
$offset = ($page-1)*$per_page;

$where = [];
$params = [];

if ($search !== '') {
  $where[] = "(la.username_attempted LIKE ? OR u.full_name LIKE ? OR la.ip_address LIKE ?)";
  $like = "%{$search}%";
  $params[]=$like; $params[]=$like; $params[]=$like;
}
if ($success === '1' || $success === '0') {
  $where[] = "la.success = ?";
  $params[] = (int)$success;
}
$whereSql = $where ? ('WHERE '.implode(' AND ', $where)) : '';

$count = $pdo->prepare("
  SELECT COUNT(*)
  FROM login_audit la
  LEFT JOIN users u ON u.id = la.user_id
  $whereSql
");
$count->execute($params);
$total = (int)$count->fetchColumn();
$total_pages = max(1, (int)ceil($total/$per_page));
if ($page > $total_pages) { $page = $total_pages; $offset = ($page-1)*$per_page; }

$st = $pdo->prepare("
  SELECT la.*, u.full_name
  FROM login_audit la
  LEFT JOIN users u ON u.id = la.user_id
  $whereSql
  ORDER BY la.id DESC
  LIMIT $per_page OFFSET $offset
");
$st->execute($params);
$rows = $st->fetchAll();

function qs_keep(array $overrides=[]): string {
  $b = $_GET;
  foreach($overrides as $k=>$v){ $b[$k]=$v; }
  return http_build_query($b);
}

$page_title = "Login Logs";
include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h3 class="mb-0">Login Logs</h3>
    <div class="text-muted small">Total: <?=h((string)$total)?> records</div>
  </div>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-6">
        <label class="form-label">Search</label>
        <input class="form-control" name="search" value="<?=h($search)?>" placeholder="Email, user name, IP...">
      </div>
      <div class="col-md-2">
        <label class="form-label">Result</label>
        <select class="form-select" name="success">
          <option value="" <?=($success===''?'selected':'')?>>All</option>
          <option value="1" <?=($success==='1'?'selected':'')?>>Success</option>
          <option value="0" <?=($success==='0'?'selected':'')?>>Failed</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Rows</label>
        <select class="form-select" name="per_page">
          <?php foreach([10,25,50,100] as $n): ?>
            <option value="<?=h((string)$n)?>" <?=($per_page===$n?'selected':'')?>><?=h((string)$n)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <button class="btn btn-primary w-100"><i class="bi bi-search me-1"></i>Apply</button>
      </div>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="card-header d-flex justify-content-between align-items-center">
    <div class="text-muted small">Page <?=h((string)$page)?> / <?=h((string)$total_pages)?></div>
    <nav>
      <ul class="pagination pagination-sm mb-0">
        <li class="page-item <?=($page<=1?'disabled':'')?>">
          <a class="page-link" href="?<?=h(qs_keep(['page'=>max(1,$page-1)]))?>">Prev</a>
        </li>
        <li class="page-item disabled"><span class="page-link"><?=h((string)$page)?></span></li>
        <li class="page-item <?=($page>=$total_pages?'disabled':'')?>">
          <a class="page-link" href="?<?=h(qs_keep(['page'=>min($total_pages,$page+1)]))?>">Next</a>
        </li>
      </ul>
    </nav>
  </div>

  <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th style="width:90px;">#</th>
          <th>User</th>
          <th>Username Attempted</th>
          <th style="width:120px;">Result</th>
          <th style="width:150px;">IP</th>
          <th>Reason</th>
          <th style="width:190px;">Time</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$rows): ?>
          <tr><td colspan="7" class="p-4 text-center text-muted">No logs found.</td></tr>
        <?php endif; ?>
        <?php foreach($rows as $r): ?>
          <?php $ok = ((int)$r['success']===1); ?>
          <tr>
            <td class="text-muted">#<?=h((string)(int)$r['id'])?></td>
            <td class="fw-semibold"><?=h((string)($r['full_name'] ?? '-'))?></td>
            <td><?=h((string)$r['username_attempted'])?></td>
            <td><span class="badge <?= $ok ? 'bg-success' : 'bg-danger' ?>"><?= $ok ? 'Success' : 'Failed' ?></span></td>
            <td class="text-muted"><?=h((string)$r['ip_address'])?></td>
            <td class="text-muted small"><?=h((string)($r['reason'] ?? ''))?></td>
            <td class="text-muted small"><?=h((string)$r['created_at'])?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
