<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);
$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st=$pdo->prepare("SHOW TABLES LIKE ?"); $st->execute([$name]); return (bool)$st->fetchColumn();
}
function q($k,$d=null){ return $_GET[$k] ?? $d; }
function date_or_default($v,$d){
  if(!$v) return $d;
  $dt=DateTime::createFromFormat('Y-m-d',$v);
  return ($dt && $dt->format('Y-m-d')===$v) ? $v : $d;
}

$today=date('Y-m-d');
$from=date_or_default(q('from'), date('Y-m-01'));
$to=date_or_default(q('to'), $today);
$item_id=(int)q('item_id', 0);

$items=$pdo->query("SELECT id, name FROM items ORDER BY name")->fetchAll();

// Price series from purchase_lines
$priceDates=[]; $priceVals=[];
if (table_exists($pdo,'purchase_lines') && table_exists($pdo,'purchases') && $item_id>0) {
  // Use COALESCE for date
  $cols=[];
  foreach (['invoice_date','purchase_date'] as $c) {
    $st=$pdo->prepare("SHOW COLUMNS FROM purchases LIKE ?"); $st->execute([$c]);
    if($st->fetchColumn()) $cols[]="p.$c";
  }
  $st=$pdo->prepare("SHOW COLUMNS FROM purchases LIKE 'purchased_at'"); $st->execute([]);
  if($st->fetchColumn()) $cols[]="DATE(p.purchased_at)";
  $st=$pdo->prepare("SHOW COLUMNS FROM purchases LIKE 'created_at'"); $st->execute([]);
  if($st->fetchColumn()) $cols[]="DATE(p.created_at)";
  if(!$cols) $cols[]="CURDATE()";
  $dateExpr="COALESCE(".implode(", ",$cols).")";

  $st=$pdo->prepare("
    SELECT $dateExpr AS d, pl.unit_cost AS v
    FROM purchase_lines pl
    JOIN purchases p ON p.id=pl.purchase_id
    WHERE pl.item_id=? AND $dateExpr BETWEEN ? AND ?
    ORDER BY d ASC, p.id ASC, pl.id ASC
  ");
  $st->execute([$item_id,$from,$to]);
  while($r=$st->fetch()){
    $priceDates[]=$r['d']; $priceVals[]=(float)$r['v'];
  }
}

// Consumption series from stock_moves
$consMonths=[]; $consVals=[];
if (table_exists($pdo,'stock_moves') && $item_id>0) {
  $st=$pdo->prepare("
    SELECT DATE_FORMAT(created_at,'%Y-%m') AS ym, SUM(ABS(qty)) AS q
    FROM stock_moves
    WHERE move_type='ISSUE_OUT' AND item_id=? AND DATE(created_at) BETWEEN ? AND ?
    GROUP BY ym
    ORDER BY ym ASC
  ");
  $st->execute([$item_id,$from,$to]);
  while($r=$st->fetch()){
    $consMonths[]=$r['ym']; $consVals[]=(int)$r['q'];
  }
}

$page_title="Charts";
include __DIR__ . '/../../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Charts</h3>
    <div class="text-muted">Price over time + consumption over time</div>
  </div>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-5">
        <label class="form-label">Product</label>
        <select class="form-select" name="item_id" required>
          <option value="0" <?=($item_id===0?'selected':'')?>>Select product…</option>
          <?php foreach($items as $it): ?>
            <option value="<?=h((int)$it['id'])?>" <?=($item_id===(int)$it['id']?'selected':'')?>><?=h($it['name'])?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">From</label>
        <input class="form-control" type="date" name="from" value="<?=h($from)?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">To</label>
        <input class="form-control" type="date" name="to" value="<?=h($to)?>">
      </div>
      <div class="col-md-2">
        <button class="btn btn-primary w-100"><i class="bi bi-funnel me-1"></i>Apply</button>
      </div>
    </div>
  </div>
</form>

<div class="row g-3">
  <div class="col-lg-6">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="mb-3">Unit price over time (USD)</h5>
        <canvas id="priceChart" height="140"></canvas>
        <?php if(!$priceDates): ?>
          <div class="text-muted small mt-2">No purchase price data in this range.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-lg-6">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="mb-3">Consumption over time (issued qty)</h5>
        <canvas id="consChart" height="140"></canvas>
        <?php if(!$consMonths): ?>
          <div class="text-muted small mt-2">No ISSUE_OUT moves in this range.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
const priceLabels = <?=json_encode($priceDates)?>;
const priceData = <?=json_encode($priceVals)?>;
const consLabels = <?=json_encode($consMonths)?>;
const consData = <?=json_encode($consVals)?>;

new Chart(document.getElementById('priceChart'), {
  type: 'line',
  data: { labels: priceLabels, datasets: [{ label: 'Unit price (USD)', data: priceData, tension: 0.2 }] },
  options: { responsive: true, plugins:{legend:{display:true}} }
});

new Chart(document.getElementById('consChart'), {
  type: 'bar',
  data: { labels: consLabels, datasets: [{ label: 'Qty issued', data: consData }] },
  options: { responsive: true, plugins:{legend:{display:true}} }
});
</script>

<?php include __DIR__ . '/../../partials/footer.php'; ?>
