<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);
$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st=$pdo->prepare("SHOW TABLES LIKE ?"); $st->execute([$name]); return (bool)$st->fetchColumn();
}
function col_exists(PDO $pdo, string $table, string $col): bool {
  $st=$pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?"); $st->execute([$col]); return (bool)$st->fetchColumn();
}
function q($k,$d=null){ return $_GET[$k] ?? $d; }
function date_or_default($v,$d){
  if(!$v) return $d;
  $dt=DateTime::createFromFormat('Y-m-d',$v);
  return ($dt && $dt->format('Y-m-d')===$v) ? $v : $d;
}

if (!table_exists($pdo,'purchases') || !table_exists($pdo,'purchase_lines')) {
  $page_title="Cost Trends";
  include __DIR__ . '/../../partials/header.php';
  echo '<div class="alert alert-danger shadow-sm">Missing tables <code>purchases</code> / <code>purchase_lines</code>.</div>';
  include __DIR__ . '/../../partials/footer.php';
  exit;
}

// Robust date expression
$parts=[];
if (col_exists($pdo,'purchases','invoice_date')) $parts[]="p.invoice_date";
if (col_exists($pdo,'purchases','purchase_date')) $parts[]="p.purchase_date";
if (col_exists($pdo,'purchases','purchased_at')) $parts[]="DATE(p.purchased_at)";
if (col_exists($pdo,'purchases','created_at')) $parts[]="DATE(p.created_at)";
if (!$parts) $parts[]="CURDATE()";
$dateExpr="COALESCE(".implode(", ",$parts).")";

$today=date('Y-m-d');
$from=date_or_default(q('from'), date('Y-01-01'));
$to=date_or_default(q('to'), $today);

$st=$pdo->prepare("
SELECT DATE_FORMAT($dateExpr,'%Y-%m') AS ym,
       SUM(pl.qty) AS qty_purchased,
       SUM(pl.qty * pl.unit_cost) AS total_cost,
       AVG(pl.unit_cost) AS avg_unit_cost
FROM purchase_lines pl
JOIN purchases p ON p.id=pl.purchase_id
WHERE $dateExpr BETWEEN ? AND ?
GROUP BY ym
ORDER BY ym DESC
");
$st->execute([$from,$to]);
$rows=$st->fetchAll();

$page_title="Cost Trends";
include __DIR__ . '/../../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Cost Trends</h3>
    <div class="text-muted">Monthly purchasing cost trends (USD)</div>
  </div>
  <a class="btn btn-outline-secondary" href="<?=h(base_url('admin/reports/cost_trends_export.php?from='.urlencode($from).'&to='.urlencode($to)))?>">
    <i class="bi bi-file-earmark-excel me-1"></i> Export Excel (CSV)
  </a>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-2">
        <label class="form-label">From</label>
        <input type="date" class="form-control" name="from" value="<?=h($from)?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">To</label>
        <input type="date" class="form-control" name="to" value="<?=h($to)?>">
      </div>
      <div class="col-md-2"><button class="btn btn-primary w-100"><i class="bi bi-funnel me-1"></i>Apply</button></div>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Month</th>
            <th class="text-end" style="width:180px;">Qty Purchased</th>
            <th class="text-end" style="width:220px;">Total Cost (USD)</th>
            <th class="text-end" style="width:220px;">Avg Unit Cost (USD)</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows): ?>
            <tr><td colspan="4" class="p-4 text-center text-muted">No data.</td></tr>
          <?php endif; ?>
          <?php foreach($rows as $r): ?>
            <tr>
              <td class="fw-semibold"><?=h($r['ym'])?></td>
              <td class="text-end"><?=h((int)$r['qty_purchased'])?></td>
              <td class="text-end fw-semibold">$<?=h(number_format((float)$r['total_cost'],2))?></td>
              <td class="text-end">$<?=h(number_format((float)$r['avg_unit_cost'],2))?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../partials/footer.php'; ?>
