<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);
$pdo = db();

function col_exists(PDO $pdo, string $table, string $col): bool {
  $st=$pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?"); $st->execute([$col]); return (bool)$st->fetchColumn();
}
function q($k,$d=null){ return $_GET[$k] ?? $d; }
function date_or_default($v,$d){
  if(!$v) return $d;
  $dt=DateTime::createFromFormat('Y-m-d',$v);
  return ($dt && $dt->format('Y-m-d')===$v) ? $v : $d;
}

$today=date('Y-m-d');
$from=date_or_default(q('from'), date('Y-01-01'));
$to=date_or_default(q('to'), $today);

$parts=[];
if (col_exists($pdo,'purchases','invoice_date')) $parts[]="p.invoice_date";
if (col_exists($pdo,'purchases','purchase_date')) $parts[]="p.purchase_date";
if (col_exists($pdo,'purchases','purchased_at')) $parts[]="DATE(p.purchased_at)";
if (col_exists($pdo,'purchases','created_at')) $parts[]="DATE(p.created_at)";
if (!$parts) $parts[]="CURDATE()";
$dateExpr="COALESCE(".implode(", ",$parts).")";

header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="cost_trends_'.$from.'_to_'.$to.'.csv"');
echo "\xEF\xBB\xBF";
$out=fopen('php://output','w');
fputcsv($out,['Month','Qty Purchased','Total Cost (USD)','Avg Unit Cost (USD)']);

$st=$pdo->prepare("
SELECT DATE_FORMAT($dateExpr,'%Y-%m') AS ym,
       SUM(pl.qty) AS qty_purchased,
       SUM(pl.qty * pl.unit_cost) AS total_cost,
       AVG(pl.unit_cost) AS avg_unit_cost
FROM purchase_lines pl
JOIN purchases p ON p.id=pl.purchase_id
WHERE $dateExpr BETWEEN ? AND ?
GROUP BY ym
ORDER BY ym DESC
");
$st->execute([$from,$to]);
while($r=$st->fetch()){
  fputcsv($out,[$r['ym'],(int)$r['qty_purchased'],number_format((float)$r['total_cost'],2),number_format((float)$r['avg_unit_cost'],2)]);
}
fclose($out);
exit;
