<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);
$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st=$pdo->prepare("SHOW TABLES LIKE ?"); $st->execute([$name]); return (bool)$st->fetchColumn();
}
function q($k,$d=null){ return $_GET[$k] ?? $d; }
function date_or_default($v,$d){
  if(!$v) return $d;
  $dt=DateTime::createFromFormat('Y-m-d',$v);
  return ($dt && $dt->format('Y-m-d')===$v) ? $v : $d;
}
function clamp_int($v,$min,$max,$d){
  if($v===null || $v==='') return $d;
  $v=(int)$v;
  if($v<$min) return $min;
  if($v>$max) return $max;
  return $v;
}
if (!table_exists($pdo,'stock_moves')) {
  $page_title="Monthly Usage";
  include __DIR__ . '/../../partials/header.php';
  echo '<div class="alert alert-danger shadow-sm">Missing table <code>stock_moves</code>.</div>';
  include __DIR__ . '/../../partials/footer.php';
  exit;
}

$today=date('Y-m-d');
$from=date_or_default(q('from'), date('Y-m-01'));
$to=date_or_default(q('to'), $today);
$search=trim((string)q('search',''));

$page=clamp_int(q('page'),1,1000000,1);
$per_page=clamp_int(q('per_page'),5,200,25);
$offset=($page-1)*$per_page;

$where=["sm.move_type='ISSUE_OUT'", "DATE(sm.created_at) BETWEEN ? AND ?"];
$params=[$from,$to];
if($search!==''){ $where[]="(i.name LIKE ?)"; $params[]="%{$search}%"; }
$whereSql="WHERE ".implode(" AND ",$where);

// total items
$count=$pdo->prepare("SELECT COUNT(*) FROM (SELECT i.id
  FROM stock_moves sm
  JOIN items i ON i.id=sm.item_id
  $whereSql
  GROUP BY i.id) x");
$count->execute($params);
$total=(int)$count->fetchColumn();
$total_pages=max(1,(int)ceil($total/$per_page));
if($page>$total_pages){ $page=$total_pages; $offset=($page-1)*$per_page; }

// By item
$sql="
SELECT i.id, i.name, i.unit,
       SUM(ABS(sm.qty)) AS qty_issued,
       COUNT(*) AS moves_count
FROM stock_moves sm
JOIN items i ON i.id=sm.item_id
$whereSql
GROUP BY i.id, i.name, i.unit
ORDER BY qty_issued DESC, i.name ASC
LIMIT $per_page OFFSET $offset
";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll();

// Totals
$tot=$pdo->prepare("SELECT COALESCE(SUM(ABS(sm.qty)),0) AS total_qty, COUNT(*) AS total_moves
FROM stock_moves sm
JOIN items i ON i.id=sm.item_id
$whereSql");
$tot->execute($params); $summary=$tot->fetch() ?: ['total_qty'=>0,'total_moves'=>0];

function qs_keep($overrides=[]){ $b=$_GET; foreach($overrides as $k=>$v){$b[$k]=$v;} return http_build_query($b); }

$page_title="Monthly Usage";
include __DIR__ . '/../../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Monthly Usage</h3>
    <div class="text-muted">Consumption from ISSUE_OUT stock moves</div>
  </div>
  <a class="btn btn-outline-secondary" href="<?=h(base_url('admin/reports/monthly_usage_export.php?'.qs_keep()))?>">
    <i class="bi bi-file-earmark-excel me-1"></i> Export Excel (CSV)
  </a>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-2">
        <label class="form-label">From</label>
        <input type="date" class="form-control" name="from" value="<?=h($from)?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">To</label>
        <input type="date" class="form-control" name="to" value="<?=h($to)?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Search item</label>
        <input class="form-control" name="search" value="<?=h($search)?>" placeholder="Item name…">
      </div>
      <div class="col-md-2">
        <label class="form-label">Rows per page</label>
        <select class="form-select" name="per_page">
          <?php foreach([10,25,50,100,200] as $n): ?>
            <option value="<?=h($n)?>" <?=($per_page===$n?'selected':'')?>><?=h($n)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2"><button class="btn btn-primary w-100"><i class="bi bi-funnel me-1"></i>Apply</button></div>
    </div>
  </div>
</form>

<div class="row g-3 mb-3">
  <div class="col-md-3"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted small">Total Qty Issued</div>
    <div class="fs-3 fw-bold"><?=h((int)$summary['total_qty'])?></div>
  </div></div></div>
  <div class="col-md-3"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted small">Total Moves</div>
    <div class="fs-3 fw-bold"><?=h((int)$summary['total_moves'])?></div>
  </div></div></div>
</div>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <div class="p-3 border-bottom d-flex justify-content-between align-items-center">
      <div class="text-muted small"><?=h($total)?> item(s) • Page <?=h($page)?> / <?=h($total_pages)?></div>
      <nav><ul class="pagination pagination-sm mb-0">
        <li class="page-item <?=($page<=1?'disabled':'')?>"><a class="page-link" href="?<?=h(qs_keep(['page'=>max(1,$page-1)]))?>">Prev</a></li>
        <li class="page-item disabled"><span class="page-link"><?=h($page)?></span></li>
        <li class="page-item <?=($page>=$total_pages?'disabled':'')?>"><a class="page-link" href="?<?=h(qs_keep(['page'=>min($total_pages,$page+1)]))?>">Next</a></li>
      </ul></nav>
    </div>

    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Item</th>
            <th class="text-end" style="width:160px;">Qty Issued</th>
            <th class="text-end" style="width:140px;">Moves</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows): ?>
            <tr><td colspan="3" class="p-4 text-center text-muted">No data.</td></tr>
          <?php endif; ?>
          <?php foreach($rows as $r): ?>
            <tr>
              <td class="fw-semibold"><?=h($r['name'])?> <span class="text-muted small">(<?=h($r['unit'])?>)</span></td>
              <td class="text-end fw-semibold"><?=h((int)$r['qty_issued'])?></td>
              <td class="text-end"><?=h((int)$r['moves_count'])?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../partials/footer.php'; ?>
