<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);
$pdo = db();

function q($k,$d=null){ return $_GET[$k] ?? $d; }
function date_or_default($v,$d){
  if(!$v) return $d;
  $dt=DateTime::createFromFormat('Y-m-d',$v);
  return ($dt && $dt->format('Y-m-d')===$v) ? $v : $d;
}

$today=date('Y-m-d');
$from=date_or_default(q('from'), date('Y-m-01'));
$to=date_or_default(q('to'), $today);
$search=trim((string)q('search',''));

$where=["sm.move_type='ISSUE_OUT'","DATE(sm.created_at) BETWEEN ? AND ?"];
$params=[$from,$to];
if($search!==''){ $where[]="i.name LIKE ?"; $params[]="%{$search}%"; }
$whereSql="WHERE ".implode(" AND ",$where);

header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="monthly_usage_'.$from.'_to_'.$to.'.csv"');
echo "\xEF\xBB\xBF";
$out=fopen('php://output','w');
fputcsv($out,['Item','Unit','Qty Issued','Moves']);

$st=$pdo->prepare("
SELECT i.name, i.unit, SUM(ABS(sm.qty)) AS qty_issued, COUNT(*) AS moves_count
FROM stock_moves sm
JOIN items i ON i.id=sm.item_id
$whereSql
GROUP BY i.id, i.name, i.unit
ORDER BY qty_issued DESC, i.name ASC
");
$st->execute($params);
while($r=$st->fetch()){
  fputcsv($out,[$r['name'],$r['unit'],(int)$r['qty_issued'],(int)$r['moves_count']]);
}
fclose($out);
exit;
