<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);
$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?");
  $st->execute([$name]);
  return (bool)$st->fetchColumn();
}
function col_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
  $st->execute([$col]);
  return (bool)$st->fetchColumn();
}
function q($k,$d=null){ return $_GET[$k] ?? $d; }
function date_or_default($v,$d){
  if(!$v) return $d;
  $dt = DateTime::createFromFormat('Y-m-d',$v);
  return ($dt && $dt->format('Y-m-d')===$v) ? $v : $d;
}

if (!table_exists($pdo,'purchases') || !table_exists($pdo,'purchase_lines') || !table_exists($pdo,'items')) {
  http_response_code(500);
  echo "Missing tables.";
  exit;
}

$hasVendors = table_exists($pdo,'vendors') && col_exists($pdo,'purchases','vendor_id');
$hasVendorNameCol = col_exists($pdo,'purchases','vendor_name') || col_exists($pdo,'purchases','vendor');

$parts = [];
if (col_exists($pdo,'purchases','invoice_date'))   $parts[] = "p.invoice_date";
if (col_exists($pdo,'purchases','purchase_date'))  $parts[] = "p.purchase_date";
if (col_exists($pdo,'purchases','purchased_at'))   $parts[] = "DATE(p.purchased_at)";
if (col_exists($pdo,'purchases','created_at'))     $parts[] = "DATE(p.created_at)";
if (!$parts) $parts[] = "CURDATE()";
$dateExpr = "COALESCE(" . implode(", ", $parts) . ")";

$vendorExpr = "'—'";
if ($hasVendors) $vendorExpr = "COALESCE(v.name,'—')";
elseif ($hasVendorNameCol) $vendorExpr = "COALESCE(p.vendor_name, p.vendor, '—')";

$today = date('Y-m-d');
$from = date_or_default(q('from'), '2000-01-01');
$to   = date_or_default(q('to'), $today);
$item_id = (int)q('item_id', 0);
$search = trim((string)q('search',''));

$where = [];
$params = [];
$where[] = "$dateExpr BETWEEN ? AND ?";
$params[] = $from; $params[] = $to;
if ($item_id > 0) { $where[] = "pl.item_id=?"; $params[] = $item_id; }
if ($search !== '') {
  $where[] = "(i.name LIKE ? OR COALESCE(p.invoice_no,'') LIKE ? OR $vendorExpr LIKE ?)";
  $like = "%{$search}%";
  $params[] = $like; $params[] = $like; $params[] = $like;
}
$whereSql = "WHERE " . implode(" AND ", $where);

$baseSql = "
  FROM purchase_lines pl
  JOIN purchases p ON p.id = pl.purchase_id
  JOIN items i ON i.id = pl.item_id
  ".($hasVendors ? "LEFT JOIN vendors v ON v.id = p.vendor_id" : "")."
  $whereSql
";

$filename = "price_history_{$from}_to_{$to}.csv";
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');
echo "\xEF\xBB\xBF";
$out = fopen('php://output','w');

$withChange = ($item_id > 0);
$headers = ['Date','Purchase #','Vendor','Invoice','Item','Qty','Unit Price (USD)','Line Total (USD)'];
if ($withChange) $headers[] = 'Change vs Previous (%)';
fputcsv($out, $headers);

$stmt = $pdo->prepare("
  SELECT
    $dateExpr AS price_date,
    p.id AS purchase_id,
    $vendorExpr AS vendor_name,
    COALESCE(p.invoice_no,'') AS invoice_no,
    i.name AS item_name,
    pl.qty,
    pl.unit_cost,
    (pl.qty * pl.unit_cost) AS line_total
  $baseSql
  ORDER BY price_date ASC, p.id ASC, pl.id ASC
");
$stmt->execute($params);
$all = $stmt->fetchAll();

$prev = null;
foreach ($all as $r) {
  $row = [
    $r['price_date'],
    '#'.$r['purchase_id'],
    $r['vendor_name'],
    $r['invoice_no'],
    $r['item_name'],
    (int)$r['qty'],
    number_format((float)$r['unit_cost'], 2),
    number_format((float)$r['line_total'], 2),
  ];
  if ($withChange) {
    $change = '';
    if ($prev !== null && (float)$prev > 0) {
      $change = number_format((((float)$r['unit_cost'] - (float)$prev) / (float)$prev) * 100.0, 2);
    }
    $row[] = $change;
    $prev = (float)$r['unit_cost'];
  }
  fputcsv($out, $row);
}
fclose($out);
exit;
