<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['ADMIN']);

$pdo = db();

function q(string $k, $default=null) { return $_GET[$k] ?? $default; }
function date_or_default($v, $default) {
  if (!$v) return $default;
  $dt = DateTime::createFromFormat('Y-m-d', $v);
  return ($dt && $dt->format('Y-m-d') === $v) ? $v : $default;
}

$today = date('Y-m-d');
$from = date_or_default(q('from'), date('Y-m-01'));
$to   = date_or_default(q('to'), $today);
$status = trim((string)q('status',''));
$requester_id = (int)q('requester_id', 0);
$search = trim((string)q('search',''));

$where = [];
$params = [];

$where[] = "DATE(r.created_at) BETWEEN ? AND ?";
$params[] = $from;
$params[] = $to;

if ($status !== '') { $where[] = "r.status = ?"; $params[] = $status; }
if ($requester_id > 0) { $where[] = "r.requester_id = ?"; $params[] = $requester_id; }
if ($search !== '') {
  $where[] = "(CAST(r.id AS CHAR) LIKE ? OR u.full_name LIKE ? OR i.name LIKE ? OR COALESCE(sk.full_name,'') LIKE ?)";
  $like = "%{$search}%";
  $params[] = $like; $params[] = $like; $params[] = $like; $params[] = $like;
}
$whereSql = $where ? ("WHERE " . implode(" AND ", $where)) : "";

$filename = "requester_report_{$from}_to_{$to}.csv";
header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');
echo "\xEF\xBB\xBF";

$out = fopen('php://output', 'w');
fputcsv($out, ['Request #','Date','Requester','Item','Qty Requested','Qty Delivered','Status','Storekeeper']);

$stmt = $pdo->prepare("
  SELECT
    r.id AS request_id,
    r.created_at,
    r.status,
    u.full_name AS requester_name,
    COALESCE(sk.full_name,'') AS storekeeper_name,
    i.name AS item_name,
    rl.qty_requested,
    rl.qty_delivered
  FROM requests r
  JOIN users u ON u.id = r.requester_id
  JOIN request_lines rl ON rl.request_id = r.id
  JOIN items i ON i.id = rl.item_id
  LEFT JOIN users sk ON sk.id = r.assigned_to_id
  $whereSql
  ORDER BY r.created_at DESC, r.id DESC
");
$stmt->execute($params);

while ($r = $stmt->fetch()) {
  fputcsv($out, [
    '#'.$r['request_id'],
    $r['created_at'],
    $r['requester_name'],
    $r['item_name'],
    (int)$r['qty_requested'],
    (int)$r['qty_delivered'],
    $r['status'],
    $r['storekeeper_name']
  ]);
}

fclose($out);
exit;
