<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN']);

$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?");
  $st->execute([$name]);
  return (bool)$st->fetchColumn();
}
function column_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
  $st->execute([$col]);
  return (bool)$st->fetchColumn();
}

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
  flash_set('danger', 'Invalid request id.');
  header('Location: ' . base_url('admin/index.php'));
  exit;
}

$hasRequests = table_exists($pdo,'requests');
$hasLines = table_exists($pdo,'request_lines');
$hasItems = table_exists($pdo,'items');
$hasUsers = table_exists($pdo,'users');

if (!$hasRequests || !$hasLines || !$hasItems || !$hasUsers) {
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-warning shadow-sm"><strong>Missing tables.</strong><br>'
     . 'This page requires <code>requests</code>, <code>request_lines</code>, <code>items</code>, <code>users</code>.</div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

// Optional columns
$hasAssigned = column_exists($pdo,'requests','assigned_to_id');
$hasSubmittedAt = column_exists($pdo,'requests','submitted_at');
$hasDeliveredAt = column_exists($pdo,'requests','delivered_at');
$hasPreparedAt = column_exists($pdo,'requests','prepared_at'); // might not exist in your schema
$hasStatus = column_exists($pdo,'requests','status');
$hasNote = column_exists($pdo,'requests','note');

$sql = "
  SELECT r.*,
         req.full_name AS requester_name, req.email AS requester_email
         " . ($hasAssigned ? ", sk.full_name AS storekeeper_name, sk.email AS storekeeper_email" : "") . "
  FROM requests r
  JOIN users req ON req.id = r.requester_id
  " . ($hasAssigned ? "LEFT JOIN users sk ON sk.id = r.assigned_to_id" : "") . "
  WHERE r.id=?
  LIMIT 1
";
$st = $pdo->prepare($sql);
$st->execute([$id]);
$r = $st->fetch();

if (!$r) {
  flash_set('danger', 'Request not found.');
  header('Location: ' . base_url('admin/index.php'));
  exit;
}

// Lines
$linesSql = "
  SELECT rl.*,
         i.name AS item_name,
         i.unit AS item_unit
  FROM request_lines rl
  JOIN items i ON i.id = rl.item_id
  WHERE rl.request_id=?
  ORDER BY i.name
";
$lst = $pdo->prepare($linesSql);
$lst->execute([$id]);
$lines = $lst->fetchAll();

function status_badge(string $s): array {
  $s = strtoupper(trim($s));
  if ($s === 'SUBMITTED') return ['bg-danger','Submitted'];
  if ($s === 'PREPARING') return ['bg-warning text-dark','Preparing'];
  if ($s === 'DELIVERED') return ['bg-success','Delivered'];
  if ($s === 'RECEIVED') return ['bg-success','Received'];
  return ['bg-secondary', $s ?: '—'];
}

$status = $hasStatus ? ($r['status'] ?? '') : '';
[$badgeClass, $badgeText] = status_badge((string)$status);

include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Request #<?=h((int)$r['id'])?></h3>
    <div class="text-muted">Admin view • Read-only</div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-secondary" href="<?=h(base_url('storekeeper/inbox.php'))?>">← Requests Inbox</a>
    <a class="btn btn-primary" href="<?=h(base_url('admin/reports/stock_movement.php'))?>">Stock Report</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-lg-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="mb-3">Header</h5>

        <div class="mb-2">
          <div class="text-muted small">Status</div>
          <span class="badge <?=h($badgeClass)?>"><?=h($badgeText)?></span>
        </div>

        <div class="mb-2">
          <div class="text-muted small">Requester</div>
          <div class="fw-semibold"><?=h($r['requester_name'] ?? '—')?></div>
          <div class="text-muted small"><?=h($r['requester_email'] ?? '')?></div>
        </div>

        <?php if ($hasAssigned): ?>
          <div class="mb-2">
            <div class="text-muted small">Assigned storekeeper</div>
            <div class="fw-semibold"><?=h($r['storekeeper_name'] ?? '—')?></div>
            <div class="text-muted small"><?=h($r['storekeeper_email'] ?? '')?></div>
          </div>
        <?php endif; ?>

        <div class="row g-2 mt-2">
          <div class="col-6">
            <div class="text-muted small">Created</div>
            <div class="fw-semibold"><?=h($r['created_at'] ?? '—')?></div>
          </div>
          <div class="col-6">
            <div class="text-muted small">Updated</div>
            <div class="fw-semibold"><?=h($r['updated_at'] ?? '—')?></div>
          </div>
        </div>

        <?php if ($hasSubmittedAt): ?>
          <div class="mt-2">
            <div class="text-muted small">Submitted at</div>
            <div class="fw-semibold"><?=h($r['submitted_at'] ?? '—')?></div>
          </div>
        <?php endif; ?>

        <?php if ($hasPreparedAt): ?>
          <div class="mt-2">
            <div class="text-muted small">Prepared at</div>
            <div class="fw-semibold"><?=h($r['prepared_at'] ?? '—')?></div>
          </div>
        <?php endif; ?>

        <?php if ($hasDeliveredAt): ?>
          <div class="mt-2">
            <div class="text-muted small">Delivered at</div>
            <div class="fw-semibold"><?=h($r['delivered_at'] ?? '—')?></div>
          </div>
        <?php endif; ?>

        <?php if ($hasNote && !empty($r['note'])): ?>
          <hr>
          <div class="text-muted small">Note</div>
          <div><?=nl2br(h($r['note']))?></div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-lg-8">
    <div class="card shadow-sm">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>Item</th>
                <th style="width:120px;">Qty requested</th>
                <?php if (isset($lines[0]['qty_delivered'])): ?>
                  <th style="width:120px;">Qty delivered</th>
                <?php endif; ?>
              </tr>
            </thead>
            <tbody>
              <?php if (!$lines): ?>
                <tr><td colspan="3" class="p-4 text-center text-muted">No items.</td></tr>
              <?php endif; ?>

              <?php foreach ($lines as $ln): ?>
                <tr>
                  <td class="fw-semibold"><?=h($ln['item_name'])?> <span class="text-muted">(<?=h($ln['item_unit'])?>)</span></td>
                  <td class="fw-semibold"><?=h((int)($ln['qty_requested'] ?? 0))?></td>
                  <?php if (array_key_exists('qty_delivered', $ln)): ?>
                    <td class="fw-semibold"><?=h((int)($ln['qty_delivered'] ?? 0))?></td>
                  <?php endif; ?>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
