<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN']);

$pdo = db();
$msg = null;
$err = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $user_id = (int)($_POST['user_id'] ?? 0);
  if ($user_id > 0) {
    try {
      $pdo->prepare("UPDATE users SET failed_login_count=0, locked_until=NULL WHERE id=?")->execute([$user_id]);
      log_activity('UNLOCK_USER', 'users', $user_id, 'Admin unlocked user');
      $msg = "User unlocked successfully.";
    } catch (Throwable $e) {
      $err = "Error: " . $e->getMessage();
    }
  }
}

$search = trim((string)($_GET['search'] ?? ''));
$params = [];
$where = "WHERE 1=1";
if ($search !== '') {
  $where .= " AND (email LIKE ? OR full_name LIKE ?)";
  $like = "%{$search}%";
  $params = [$like, $like];
}

$st = $pdo->prepare("
  SELECT id, full_name, email, role, failed_login_count, locked_until,
         (locked_until IS NOT NULL AND locked_until > NOW()) AS is_locked
  FROM users
  $where
  ORDER BY is_locked DESC, full_name ASC
  LIMIT 200
");
$st->execute($params);
$rows = $st->fetchAll();

$page_title = "Unlock Users";
include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h3 class="mb-0">Unlock Users</h3>
    <div class="text-muted small">Search users and unlock locked accounts.</div>
  </div>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-8">
        <label class="form-label">Search</label>
        <input class="form-control" name="search" value="<?=h($search)?>" placeholder="Name or Email">
      </div>
      <div class="col-md-4">
        <button class="btn btn-primary w-100"><i class="bi bi-search me-1"></i>Search</button>
      </div>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>User</th>
          <th>Email</th>
          <th>Role</th>
          <th style="width:120px;">Attempts</th>
          <th style="width:220px;">Locked Until</th>
          <th style="width:140px;">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$rows): ?>
          <tr><td colspan="6" class="p-4 text-center text-muted">No users found.</td></tr>
        <?php endif; ?>
        <?php foreach ($rows as $u): ?>
          <?php $locked = ((int)$u['is_locked'] === 1); ?>
          <tr>
            <td class="fw-semibold">
              <?=h($u['full_name'])?>
              <?php if ($locked): ?><span class="badge bg-danger ms-2">Locked</span><?php endif; ?>
            </td>
            <td class="text-muted"><?=h($u['email'])?></td>
            <td><span class="badge bg-secondary"><?=h($u['role'])?></span></td>
            <td class="text-muted"><?=h((string)(int)$u['failed_login_count'])?></td>
            <td class="text-muted small"><?=h((string)($u['locked_until'] ?? ''))?></td>
            <td>
              <?php if ($locked): ?>
                <form method="post" class="m-0">
                  <input type="hidden" name="user_id" value="<?=h((string)(int)$u['id'])?>">
                  <button class="btn btn-sm btn-success"><i class="bi bi-unlock me-1"></i>Unlock</button>
                </form>
              <?php else: ?>
                <span class="text-muted small">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
