<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN']);

$pdo = db();
$users = $pdo->query("SELECT id, full_name, email, role, is_active, created_at FROM users ORDER BY id DESC")->fetchAll();

include __DIR__ . '/../partials/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Users</h3>
  <a class="btn btn-secondary" href="<?=h(base_url('admin/items.php'))?>">Back to Items</a>
</div>

<div class="card card-body mb-4">
  <h5>Create User</h5>
  <form method="post" action="<?=h(base_url('admin/actions/user_create.php'))?>" class="row g-2">
    <div class="col-md-3"><input class="form-control" name="full_name" placeholder="Full name" required></div>
    <div class="col-md-3"><input class="form-control" name="email" type="email" placeholder="Email" required></div>
    <div class="col-md-2">
      <select class="form-select" name="role" required>
        <option value="REQUESTER">REQUESTER</option>
        <option value="STOREKEEPER">STOREKEEPER</option>
        <option value="ADMIN">ADMIN</option>
      </select>
    </div>
    <div class="col-md-2"><input class="form-control" name="password" type="text" placeholder="Temp password" required></div>
    <div class="col-md-1">
      <select class="form-select" name="is_active">
        <option value="1">Active</option>
        <option value="0">Inactive</option>
      </select>
    </div>
    <div class="col-md-1"><button class="btn btn-success w-100">Add</button></div>
  </form>
  <div class="form-text mt-2">Tip: After creating a user, you can reset their password anytime below.</div>
</div>

<table class="table table-striped align-middle">
  <thead>
    <tr>
      <th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Active</th><th>Created</th><th style="width:340px;">Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($users as $u): ?>
      <tr>
        <td>#<?=h($u['id'])?></td>
        <td><?=h($u['full_name'])?></td>
        <td><?=h($u['email'])?></td>
        <td>
          <form method="post" action="<?=h(base_url('admin/actions/user_update_role.php'))?>" class="d-flex gap-2">
            <input type="hidden" name="id" value="<?=h($u['id'])?>">
            <select class="form-select form-select-sm" name="role">
              <option value="REQUESTER" <?=($u['role']==='REQUESTER'?'selected':'')?>>REQUESTER</option>
              <option value="STOREKEEPER" <?=($u['role']==='STOREKEEPER'?'selected':'')?>>STOREKEEPER</option>
              <option value="ADMIN" <?=($u['role']==='ADMIN'?'selected':'')?>>ADMIN</option>
            </select>
            <button class="btn btn-sm btn-outline-primary">Save</button>
          </form>
        </td>
        <td><?=((int)$u['is_active']===1) ? 'Yes' : 'No'?></td>
        <td><?=h($u['created_at'])?></td>
        <td class="d-flex flex-wrap gap-2">
          <form method="post" action="<?=h(base_url('admin/actions/user_toggle.php'))?>" onsubmit="return confirm('Toggle active status?')">
            <input type="hidden" name="id" value="<?=h($u['id'])?>">
            <button class="btn btn-sm btn-outline-warning">Toggle Active</button>
          </form>

          <form method="post" action="<?=h(base_url('admin/actions/user_reset_password.php'))?>" onsubmit="return confirm('Reset password to the value entered?')">
            <input type="hidden" name="id" value="<?=h($u['id'])?>">
            <input class="form-control form-control-sm" style="width:150px" name="new_password" placeholder="New password" required>
            <button class="btn btn-sm btn-outline-danger">Reset</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<?php include __DIR__ . '/../partials/footer.php'; ?>
