<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['ADMIN','STOREKEEPER']);
$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?");
  $st->execute([$name]);
  return (bool)$st->fetchColumn();
}

include __DIR__ . '/../partials/header.php';

if (!table_exists($pdo, 'vendors')) {
  echo '<div class="alert alert-warning shadow-sm"><strong>Vendors table not found.</strong><br>'
     . 'Run the SQL file: <code>sql/upgrade_purchases_vendors_invoice_vat.sql</code></div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

// Add vendor
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'add') {
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $address = trim($_POST['address'] ?? '');

  if ($name === '') {
    flash_set('danger', 'Please enter vendor name.');
  } else {
    $chk = $pdo->prepare("SELECT id FROM vendors WHERE LOWER(name)=LOWER(?) LIMIT 1");
    $chk->execute([$name]);
    if ($chk->fetchColumn()) {
      flash_set('danger', 'Vendor already exists.');
    } else {
      $pdo->prepare("INSERT INTO vendors(name,email,phone,address) VALUES(?,?,?,?)")
          ->execute([$name, ($email===''?null:$email), ($phone===''?null:$phone), ($address===''?null:$address)]);
      flash_set('success', 'Vendor added successfully.');
    }
  }
  header('Location: ' . base_url('admin/vendors.php'));
  exit;
}

// Update vendor
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'update') {
  $id = (int)($_POST['id'] ?? 0);
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $address = trim($_POST['address'] ?? '');

  if ($id <= 0 || $name === '') {
    flash_set('danger', 'Invalid vendor.');
  } else {
    // prevent duplicate name
    $chk = $pdo->prepare("SELECT id FROM vendors WHERE LOWER(name)=LOWER(?) AND id<>? LIMIT 1");
    $chk->execute([$name, $id]);
    if ($chk->fetchColumn()) {
      flash_set('danger', 'Another vendor already has this name.');
    } else {
      $pdo->prepare("UPDATE vendors SET name=?, email=?, phone=?, address=? WHERE id=?")
          ->execute([$name, ($email===''?null:$email), ($phone===''?null:$phone), ($address===''?null:$address), $id]);
      flash_set('success', 'Vendor updated.');
    }
  }
  header('Location: ' . base_url('admin/vendors.php'));
  exit;
}

// Delete vendor (only if not used)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'delete') {
  $id = (int)($_POST['id'] ?? 0);
  if ($id <= 0) {
    flash_set('danger', 'Invalid vendor.');
  } else {
    $used = $pdo->prepare("SELECT COUNT(*) FROM purchases WHERE vendor_id=?");
    $used->execute([$id]);
    if ((int)$used->fetchColumn() > 0) {
      flash_set('danger', 'Cannot delete: vendor is used in purchases.');
    } else {
      $pdo->prepare("DELETE FROM vendors WHERE id=?")->execute([$id]);
      flash_set('success', 'Vendor deleted.');
    }
  }
  header('Location: ' . base_url('admin/vendors.php'));
  exit;
}

$vendors = $pdo->query("SELECT * FROM vendors ORDER BY name")->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h3 class="mb-1">Vendors</h3>
    <div class="text-muted">Manage supplier list for purchases</div>
  </div>
  <a class="btn btn-outline-secondary" href="<?=h(base_url('admin/purchases_new.php'))?>">Back to Purchases</a>
</div>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h5 class="mb-3">Add Vendor</h5>
    <form method="post" class="row g-2">
      <input type="hidden" name="action" value="add">
      <div class="col-md-3">
        <label class="form-label">Name</label>
        <input class="form-control" name="name" required placeholder="Vendor name">
      </div>
      <div class="col-md-3">
        <label class="form-label">Email</label>
        <input class="form-control" name="email" placeholder="optional">
      </div>
      <div class="col-md-2">
        <label class="form-label">Phone</label>
        <input class="form-control" name="phone" placeholder="optional">
      </div>
      <div class="col-md-3">
        <label class="form-label">Address</label>
        <input class="form-control" name="address" placeholder="optional">
      </div>
      <div class="col-md-1 d-flex align-items-end">
        <button class="btn btn-success w-100">Add</button>
      </div>
    </form>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Name</th><th>Email</th><th>Phone</th><th>Address</th><th style="width:260px;"></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$vendors): ?>
            <tr><td colspan="5" class="p-4 text-center text-muted">No vendors yet.</td></tr>
          <?php endif; ?>
          <?php foreach ($vendors as $v): ?>
            <tr>
              <form method="post">
                <input type="hidden" name="action" value="update">
                <input type="hidden" name="id" value="<?=h((int)$v['id'])?>">
                <td><input class="form-control form-control-sm" name="name" value="<?=h($v['name'])?>"></td>
                <td><input class="form-control form-control-sm" name="email" value="<?=h($v['email'] ?? '')?>"></td>
                <td><input class="form-control form-control-sm" name="phone" value="<?=h($v['phone'] ?? '')?>"></td>
                <td><input class="form-control form-control-sm" name="address" value="<?=h($v['address'] ?? '')?>"></td>
                <td class="text-end">
                  <button class="btn btn-sm btn-primary">Save</button>
              </form>
                  <form method="post" class="d-inline" onsubmit="return confirm('Delete this vendor?');">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="id" value="<?=h((int)$v['id'])?>">
                    <button class="btn btn-sm btn-outline-danger">Delete</button>
                  </form>
                </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
