<?php
require_once __DIR__ . '/../lib/bootstrap.php';

header('Content-Type: application/json; charset=UTF-8');

$u = current_user();
if (!$u) { http_response_code(401); echo json_encode(['count'=>0]); exit; }
if (!in_array($u['role'], ['ADMIN','STOREKEEPER'], true)) { http_response_code(403); echo json_encode(['count'=>0]); exit; }

$pdo = db();

$thCol = null;
$st = $pdo->prepare("SHOW COLUMNS FROM items LIKE ?");
$st->execute(['threshold_qty']);
if ($st->fetchColumn()) $thCol = 'threshold_qty';
else {
  $st->execute(['threshold']);
  if ($st->fetchColumn()) $thCol = 'threshold';
}

if (!$thCol) { echo json_encode(['count'=>0]); exit; }

$count = (int)$pdo->query("
  SELECT COUNT(*)
  FROM items
  WHERE COALESCE($thCol,0) > 0
    AND stock_qty <= COALESCE($thCol,0)
")->fetchColumn();

echo json_encode(['count'=>$count]);
