<?php
ini_set('display_errors', 0);
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);

require_once __DIR__ . '/../lib/bootstrap.php';

function audit_login(PDO $pdo, string $username, ?int $userId, int $success, string $reason): void {
    try {
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        $ua = substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255);

        $stmt = $pdo->prepare("
            INSERT INTO login_audit
              (username_attempted, user_id, success, ip_address, user_agent, reason)
            VALUES (?,?,?,?,?,?)
        ");
        $stmt->execute([$username, $userId, $success, $ip, $ua, $reason]);
    } catch (Throwable $e) {
        error_log('[LOGIN_AUDIT] ' . $e->getMessage());
    }
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';

    $pdo = db();

    $stmt = $pdo->prepare("
        SELECT id, email, full_name, role, password_hash, is_active,
               failed_login_count, locked_until
        FROM users
        WHERE email = ?
        LIMIT 1
    ");
    $stmt->execute([$email]);
    $u = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($u) {

        // 🔒 Check if locked
        if (!empty($u['locked_until']) && strtotime($u['locked_until']) > time()) {
            audit_login($pdo, $email, (int)$u['id'], 0, 'Account locked');
            $error = 'Your account is locked. Please contact the administrator.';
        }

        // ✅ Correct password
        elseif ((int)$u['is_active'] === 1 && password_verify($pass, $u['password_hash'])) {

            // Reset counters
            $pdo->prepare("
                UPDATE users
                SET failed_login_count = 0, locked_until = NULL
                WHERE id = ?
            ")->execute([(int)$u['id']]);

            audit_login($pdo, $email, (int)$u['id'], 1, 'Login success');

            unset($u['password_hash']);
            $_SESSION['user'] = $u;

            // 🎯 ROLE-BASED REDIRECT (THIS FIXES YOUR 403 ISSUE)
            switch ($u['role']) {
                case 'ADMIN':
                    header('Location: ' . base_url('admin/'));
				 header('Location: ' . base_url('admin/items.php'));

                    break;

                case 'STOREKEEPER':
                    header('Location: ' . base_url('storekeeper/inbox.php'));
                    break;

                case 'REQUESTER':
                default:
                    header('Location: ' . base_url('requester/my_requests.php'));
                    break;
            }
            exit;
        }

        // ❌ Wrong password
        else {
            $pdo->prepare("
                UPDATE users
                SET failed_login_count = failed_login_count + 1
                WHERE id = ?
            ")->execute([(int)$u['id']]);

            $cnt = (int)$pdo->query("
                SELECT failed_login_count FROM users WHERE id = {$u['id']}
            ")->fetchColumn();

            if ($cnt >= 3) {
                $pdo->prepare("
                    UPDATE users
                    SET locked_until = DATE_ADD(NOW(), INTERVAL 3650 DAY)
                    WHERE id = ?
                ")->execute([(int)$u['id']]);

                audit_login($pdo, $email, (int)$u['id'], 0, 'Locked after 3 attempts');
                $error = 'Too many failed attempts. Your account is now locked.';
            } else {
                audit_login($pdo, $email, (int)$u['id'], 0, 'Wrong password');
                $error = 'Invalid login credentials.';
            }
        }

    } else {
        // ❌ User not found
        audit_login($pdo, $email, null, 0, 'User not found');
        $error = 'Invalid login credentials.';
    }
}

$page_title = 'Login';
include __DIR__ . '/../partials/header.php';
?>

<div class="row justify-content-center">
  <div class="col-md-4">
    <form method="post" class="card card-body shadow-sm" autocomplete="off">
      <h4 class="mb-3 text-center">Login</h4>

      <?php if ($error): ?>
        <div class="alert alert-danger"><?=h($error)?></div>
      <?php endif; ?>

      <div class="mb-3">
        <label>Email</label>
        <input name="email" type="email" class="form-control" required autocomplete="username">
      </div>

      <div class="mb-3">
        <label>Password</label>
        <input name="password" type="password" class="form-control" required autocomplete="new-password">
      </div>

      <button class="btn btn-primary w-100">Login</button>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
