<?php
require_once __DIR__ . '/bootstrap.php';

function assign_storekeeper_id(PDO $pdo): ?int {
  $stmt = $pdo->query("
    SELECT id
    FROM users
    WHERE role='STOREKEEPER' AND is_active=1
    ORDER BY (last_assigned_at IS NOT NULL), last_assigned_at ASC
    LIMIT 1
  ");
  $row = $stmt->fetch();
  if (!$row) return null;

  $id = (int)$row['id'];
  $up = $pdo->prepare("UPDATE users SET last_assigned_at = NOW() WHERE id = ?");
  $up->execute([$id]);
  return $id;
}
