<?php
require_once __DIR__ . '/bootstrap.php';

/**
 * send_email()
 * Uses PHP mail() with better headers + logging.
 */
function send_email(string $to, string $subject, string $htmlBody): bool {
  $cfg = require base_path('config/mail.php');

  $to = trim($to);
  if ($to === '' || !filter_var($to, FILTER_VALIDATE_EMAIL)) {
    error_log("[MAIL] SKIP invalid TO='{$to}' subject='{$subject}'");
    return false;
  }

  $fromEmail = $cfg['from_email'] ?? 'no-reply@example.com';
  $fromName  = $cfg['from_name']  ?? 'Consumables System';

  $headers  = "MIME-Version: 1.0\r\n";
  $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
  $headers .= "From: {$fromName} <{$fromEmail}>\r\n";
  $headers .= "Reply-To: {$fromEmail}\r\n";
  $headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";

  if (!empty($cfg['cc_emails'])) {
    $headers .= "Cc: {$cfg['cc_emails']}\r\n";
  }

  $ok = mail($to, $subject, $htmlBody, $headers);
  error_log("[MAIL] ".($ok ? "SENT" : "FAILED")." to='{$to}' subject='{$subject}'");
  return $ok;
}
