<?php
// partials/header.php (details dropdown + auto-close + icons + sticky) - NO DB calls here
if (!isset($page_title)) $page_title = 'Stock';

// If bootstrap.php is loaded, these exist. Keep safe guards for direct access.
if (!function_exists('current_user')) { function current_user(){ return $_SESSION['user'] ?? null; } }
if (!function_exists('base_url')) { function base_url(string $path=''): string { return '/stock/' . ltrim($path,'/'); } }
if (!function_exists('h')) { function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); } }

$u = current_user();
$role = strtoupper((string)($u['role'] ?? ''));

function nav_a(string $href, string $label, string $icon=''): string {
  $i = $icon ? '<i class="'.h($icon).' me-2"></i>' : '';
  return '<a class="menu-item" href="'.h($href).'">'.$i.h($label).'</a>';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?=h($page_title)?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

  <style>
    body{background:#f6f7fb}
    .topbar{position:sticky;top:0;z-index:1030}
    .brand{font-weight:700;letter-spacing:.2px}

    .menu-bar{display:flex;gap:.5rem;flex-wrap:wrap;align-items:center}
    details.menu{position:relative}
    details.menu > summary{list-style:none}
    details.menu > summary::-webkit-details-marker{display:none}
    .menu-btn{
      display:inline-flex;align-items:center;gap:.5rem;
      padding:.45rem .65rem;border-radius:.6rem;
      color:#fff;cursor:pointer;user-select:none;
    }
    .menu-btn:hover{background:rgba(255,255,255,.08)}
    .menu-text{font-weight:600}

    .menu-panel{
      position:absolute;left:0;top:calc(100% + .4rem);
      min-width:250px;background:#fff;border-radius:.9rem;
      box-shadow:0 12px 30px rgba(0,0,0,.16);
      padding:.35rem;display:flex;flex-direction:column;gap:.1rem;
      border:1px solid rgba(0,0,0,.06);
    }
    details.menu[open] .menu-panel{animation:drop .12s ease-out}
    @keyframes drop{from{transform:translateY(-4px);opacity:.6}to{transform:translateY(0);opacity:1}}

    .menu-item{
      display:flex;align-items:center;gap:.5rem;
      padding:.55rem .65rem;border-radius:.65rem;
      color:#111;text-decoration:none;
    }
    .menu-item:hover{background:#f2f4f8}
    .menu-divider{height:1px;background:#eceff5;margin:.25rem .35rem}

    .badge-mini{font-size:.72rem; line-height:1; padding:.25em .45em}
    .pill-link{display:inline-flex;align-items:center;gap:.4rem;text-decoration:none}
    .pill{display:inline-flex;align-items:center;gap:.4rem;padding:.25rem .55rem;border-radius:999px;font-size:.8rem}
    .pill.warn{background:#fff3cd;color:#664d03;border:1px solid rgba(255,193,7,.3)}
  </style>
</head>
<body>

<nav class="navbar navbar-dark bg-dark topbar shadow-sm">
  <div class="container-fluid d-flex justify-content-between align-items-center">
    <div class="d-flex align-items-center gap-3">
      <a class="navbar-brand brand" href="<?=h(base_url('index.php'))?>">
        <i class="bi bi-boxes me-2"></i>ARM Stock System
      </a>

      <?php if ($u): ?>
      <div class="menu-bar">

        <?php if (in_array($role, ['ADMIN','STOREKEEPER'], true)): ?>
        <details class="menu">
          <summary class="menu-btn">
            <i class="bi bi-archive"></i>
            <span class="menu-text">Inventory</span>
            <!-- Low-stock badge filled by JS (no DB call in header) -->
            <span id="invLowStockBadge" class="badge bg-danger badge-mini ms-1" style="display:none"></span>
            <i class="bi bi-chevron-down ms-1"></i>
          </summary>
          <div class="menu-panel">
            <?=nav_a(base_url('admin/items.php'), 'Items', 'bi bi-box-seam')?>
            <?php if ($role === 'ADMIN'): ?>
              <?=nav_a(base_url('admin/categories.php'), 'Categories', 'bi bi-tags')?>
            <?php endif; ?>
            <div class="menu-divider"></div>
            <?php if ($role === 'ADMIN'): ?>
              <?=nav_a(base_url('admin/items.php#low-stock'), 'Low Stock List', 'bi bi-exclamation-triangle')?>
            <?php else: ?>
              <?=nav_a(base_url('storekeeper/alerts.php'), 'Stock Alerts', 'bi bi-exclamation-triangle')?>
            <?php endif; ?>
          </div>
        </details>
        <?php endif; ?>

        <?php if ($role === 'REQUESTER'): ?>
        <details class="menu">
          <summary class="menu-btn">
            <i class="bi bi-ui-checks"></i>
            <span class="menu-text">Requests</span>
            <i class="bi bi-chevron-down ms-1"></i>
          </summary>
          <div class="menu-panel">
            <?=nav_a(base_url('requester/my_requests.php'), 'My Requests', 'bi bi-list-check')?>
            <?=nav_a(base_url('requester/new_request.php'), 'New Request', 'bi bi-plus-circle')?>
          </div>
        </details>
        <?php endif; ?>

        <?php if (in_array($role, ['STOREKEEPER','ADMIN'], true)): ?>
        <details class="menu">
          <summary class="menu-btn">
            <i class="bi bi-shop"></i>
            <span class="menu-text">Store</span>
            <i class="bi bi-chevron-down ms-1"></i>
          </summary>
          <div class="menu-panel">
            <?=nav_a(base_url('storekeeper/inbox.php'), 'Requests Inbox', 'bi bi-inbox')?>
            <?=nav_a(base_url('admin/purchases_new.php'), 'New Purchase', 'bi bi-cart-plus')?>
            <?=nav_a(base_url('admin/vendors.php'), 'Vendors', 'bi bi-buildings')?>
            <?php if ($role === 'ADMIN'): ?>
              <div class="menu-divider"></div>
              <?=nav_a(base_url('admin/purchases.php'), 'All Purchases', 'bi bi-receipt')?>
              <?=nav_a(base_url('admin/users.php'), 'Users', 'bi bi-people')?>
            <?php endif; ?>
          </div>
        </details>
        <?php endif; ?>

        <?php if ($role === 'ADMIN'): ?>
        <details class="menu">
          <summary class="menu-btn">
            <i class="bi bi-graph-up"></i>
            <span class="menu-text">Reports</span>
            <i class="bi bi-chevron-down ms-1"></i>
          </summary>
          <div class="menu-panel">
            <?=nav_a(base_url('admin/alerts.php'), 'Stock Alerts', 'bi bi-exclamation-triangle')?>
            <?=nav_a(base_url('admin/reports/stock_movement.php'), 'Stock Movement', 'bi bi-list-columns')?>
            <?=nav_a(base_url('admin/reports/requester_report.php'), 'Requester Report', 'bi bi-people')?>
            <?=nav_a(base_url('admin/reports/price_history.php'), 'Price History', 'bi bi-currency-dollar')?>
            <div class="menu-divider"></div>
            <?=nav_a(base_url('admin/reports/monthly_usage.php'), 'Monthly Usage', 'bi bi-calendar2-week')?>
            <?=nav_a(base_url('admin/reports/cost_trends.php'), 'Cost Trends', 'bi bi-bar-chart')?>
            <?=nav_a(base_url('admin/reports/charts.php'), 'Charts', 'bi bi-activity')?>
            <div class="menu-divider"></div>
            <?=nav_a(base_url('admin/vat_rates.php'), 'VAT Config', 'bi bi-percent')?>
          </div>
        </details>
        

        <?php if ($role === 'ADMIN'): ?>
        <details class="menu">
          <summary class="menu-btn">
            <i class="bi bi-shield-lock"></i>
            <span class="menu-text">Logs</span>
            <i class="bi bi-chevron-down ms-1"></i>
          </summary>
          <div class="menu-panel">
            <?=nav_a(base_url('admin/login_logs.php'), 'Login Logs', 'bi bi-box-arrow-in-right')?>
            <?=nav_a(base_url('admin/activity_logs.php'), 'Activity Logs', 'bi bi-activity')?>
			  <?=nav_a(base_url('admin/unlock_users.php'), 'Unlock Users', 'bi bi-unlock')?>

          </div>
        </details>
        <?php endif; ?>
<?php endif; ?>

      </div>
      <?php endif; ?>
    </div>

    <div class="d-flex align-items-center gap-3">
      <?php if ($u): ?>
        <!-- Header pill (kept) -->
        <?php if (in_array($role, ['ADMIN','STOREKEEPER'], true)): ?>
          <a class="pill-link" href="<?=h($role==='ADMIN' ? base_url('admin/items.php#low-stock') : base_url('storekeeper/alerts.php'))?>">
            <span class="pill warn">
              <i class="bi bi-exclamation-triangle"></i>
              Low Stock: <span id="lowStockPillCount">0</span>
            </span>
          </a>
        <?php endif; ?>

        <details class="menu">
          <summary class="menu-btn">
            <i class="bi bi-person-circle"></i>
            <span class="menu-text"><?=h((string)($u['full_name'] ?? 'User'))?></span>
            <i class="bi bi-chevron-down ms-1"></i>
          </summary>
          <div class="menu-panel" style="right:0;left:auto;min-width:220px;">
            <div class="px-2 py-1 text-muted small"><?=h($role)?></div>
            <div class="menu-divider"></div>
            <?=nav_a(base_url('account/change_password.php'), 'Change Password', 'bi bi-key')?>
            <div class="menu-divider"></div>
            <?=nav_a(base_url('auth/logout.php'), 'Logout', 'bi bi-box-arrow-right')?>
          </div>
        </details>
      <?php else: ?>
        <a class="btn btn-outline-light btn-sm" href="<?=h(base_url('auth/login.php'))?>">
          <i class="bi bi-box-arrow-in-right me-1"></i>Login
        </a>
      <?php endif; ?>
    </div>
  </div>
</nav>

<main class="container py-4">

<script>
document.addEventListener('toggle', function(e){
  const el = e.target;
  if (!(el instanceof HTMLDetailsElement) || !el.classList.contains('menu')) return;
  if (!el.open) return;
  document.querySelectorAll('details.menu[open]').forEach(d => { if (d !== el) d.open = false; });
}, true);

document.addEventListener('click', function(e){
  document.querySelectorAll('details.menu[open]').forEach(d => {
    if (!d.contains(e.target)) d.open = false;
  });
});

(async function(){
  try{
    const res = await fetch('<?=h(base_url('api/low_stock_count.php'))?>', {headers:{'Accept':'application/json'}});
    if(!res.ok) return;
    const data = await res.json();
    const n = Number(data.count || 0);
    const badge = document.getElementById('invLowStockBadge');
    const pill = document.getElementById('lowStockPillCount');
    if (pill) pill.textContent = String(n);
    if (badge) {
      if (n > 0) { badge.style.display='inline-block'; badge.textContent=String(n); }
      else { badge.style.display='none'; }
    }
  } catch(e){}
})();
</script>
