<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_once __DIR__ . '/../../lib/mailer.php';
require_role(['REQUESTER']);

$u = current_user();
$id = (int)($_POST['id'] ?? 0);

$pdo = db();
$pdo->beginTransaction();
try {
  $stmt = $pdo->prepare("
    SELECT r.*, sk.email AS sk_email, sk.full_name AS sk_name
    FROM requests r
    LEFT JOIN users sk ON sk.id = r.assigned_to_id
    WHERE r.id=? AND r.requester_id=?
    FOR UPDATE
  ");
  $stmt->execute([$id, $u['id']]);
  $r = $stmt->fetch();
  if (!$r) throw new Exception("Request not found.");
  if ($r['status'] !== 'DELIVERED') throw new Exception("Request is not in DELIVERED status.");

  $pdo->prepare("UPDATE requests SET status='RECEIVED', received_at=NOW(), updated_at=NOW() WHERE id=?")->execute([$id]);
  $pdo->commit();

  if (!empty($r['sk_email'])) {
    send_email($r['sk_email'], "Request #{$id} received", "<p>Hello ".h($r['sk_name']).",</p><p>Requester confirmed receipt for request #{$id}.</p>");
  }

  flash_set('success', "Confirmed received.");
  header('Location: ' . base_url('requester/request_view.php?id=' . $id));
  exit;
} catch (Throwable $e) {
  $pdo->rollBack();
  flash_set('danger', 'Error: ' . $e->getMessage());
  header('Location: ' . base_url('requester/request_view.php?id=' . $id));
  exit;
}
