<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_once __DIR__ . '/../../lib/notifications.php';
require_role(['REQUESTER']);

$u = current_user();
$pdo = db();

$note = trim((string)($_POST['note'] ?? ''));
$lines = $_POST['lines'] ?? [];

if (!is_array($lines) || count($lines) === 0) {
  flash_set('danger', 'Please add at least one item.');
  header('Location: ' . base_url('requester/new_request.php'));
  exit;
}

// Normalize lines (merge duplicates)
$clean = [];
foreach ($lines as $ln) {
  $item_id = (int)($ln['item_id'] ?? 0);
  $qty = (int)($ln['qty'] ?? 0);
  if ($item_id <= 0 || $qty <= 0) continue;
  $clean[$item_id] = ($clean[$item_id] ?? 0) + $qty;
}

if (!$clean) {
  flash_set('danger', 'Please add valid items and quantities.');
  header('Location: ' . base_url('requester/new_request.php'));
  exit;
}

function col_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
  $st->execute([$col]);
  return (bool)$st->fetchColumn();
}

try {
  $pdo->beginTransaction();

  // AUTO routing: requester does NOT choose storekeeper. Keep assigned_to_id NULL.
  if (col_exists($pdo, 'requests', 'assigned_to_id')) {
    $pdo->prepare("
      INSERT INTO requests (requester_id, assigned_to_id, status, note, created_at, updated_at)
      VALUES (?, NULL, 'SUBMITTED', ?, NOW(), NOW())
    ")->execute([(int)$u['id'], $note]);
  } else {
    $pdo->prepare("
      INSERT INTO requests (requester_id, status, note, created_at, updated_at)
      VALUES (?, 'SUBMITTED', ?, NOW(), NOW())
    ")->execute([(int)$u['id'], $note]);
  }

  $request_id = (int)$pdo->lastInsertId();

  $insLine = $pdo->prepare("
    INSERT INTO request_lines (request_id, item_id, qty_requested, qty_delivered)
    VALUES (?, ?, ?, 0)
  ");
  foreach ($clean as $item_id => $qty) {
    $insLine->execute([$request_id, (int)$item_id, (int)$qty]);
  }

  $pdo->commit();

  // Email ALL storekeepers (since not assigned)
  notify_storekeepers_new_request($request_id);

  flash_set('success', "Request #{$request_id} submitted.");
  header('Location: ' . base_url('requester/request_view.php?id=' . $request_id));
  exit;

} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  flash_set('danger', 'Error: ' . $e->getMessage());
  header('Location: ' . base_url('requester/new_request.php'));
  exit;
}
