<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_once __DIR__ . '/../../lib/assign.php';
require_once __DIR__ . '/../../lib/mailer.php';
require_role(['REQUESTER']);

$u = current_user();
$note = trim($_POST['note'] ?? '');
$lines = $_POST['lines'] ?? [];

if (!is_array($lines) || count($lines) < 1) {
  flash_set('danger', 'Add at least one item.');
  header('Location: ' . base_url('requester/new_request.php'));
  exit;
}

$pdo = db();
$pdo->beginTransaction();
try {
  $assignedId = assign_storekeeper_id($pdo);
  if (!$assignedId) throw new Exception('No active storekeeper found. Ask admin to add/activate storekeepers.');

  $pdo->prepare("INSERT INTO requests(requester_id, assigned_to_id, status, note) VALUES(?,?, 'SUBMITTED', ?)")
      ->execute([$u['id'], $assignedId, $note]);
  $requestId = (int)$pdo->lastInsertId();

  $ins = $pdo->prepare("INSERT INTO request_lines(request_id, item_id, qty_requested) VALUES(?,?,?)");
  $count = 0;
  foreach ($lines as $ln) {
    $itemId = (int)($ln['item_id'] ?? 0);
    $qty = (int)($ln['qty'] ?? 0);
    if ($itemId <= 0 || $qty <= 0) continue;
    $ins->execute([$requestId, $itemId, $qty]);
    $count++;
  }
  if ($count < 1) throw new Exception("No valid lines.");

  $pdo->commit();

  $sk = $pdo->prepare("SELECT email, full_name FROM users WHERE id=?");
  $sk->execute([$assignedId]);
  $sk = $sk->fetch();

  if ($sk && $sk['email']) {
    $subject = "New request #{$requestId}";
    $body = "<p>Hello ".h($sk['full_name']).",</p>
             <p>A new request (#{$requestId}) has been assigned to you.</p>
             <p>Open: <a href='".h(site_url('storekeeper/request_view.php?id='.$requestId))."'>Request #{$requestId}</a></p>";
    send_email($sk['email'], $subject, $body);
  }

  flash_set('success', "Request submitted (#{$requestId}).");
  header('Location: ' . base_url('requester/request_view.php?id=' . $requestId));
  exit;
} catch (Throwable $e) {
  $pdo->rollBack();
  flash_set('danger', 'Error: ' . $e->getMessage());
  header('Location: ' . base_url('requester/new_request.php'));
  exit;
}
