<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['REQUESTER']);

$items = db()->query("SELECT id, name, unit, stock_qty FROM items WHERE is_active=1 ORDER BY name")->fetchAll();

include __DIR__ . '/../partials/header.php';
?>
<h3>New Request</h3>

<form method="post" action="<?=h(base_url('requester/actions/submit_request.php'))?>" class="card card-body">
  <div class="row g-2 align-items-end">
    <div class="col-md-7">
      <label class="form-label">Item</label>
      <select class="form-select" id="item_id">
        <?php foreach ($items as $it): ?>
          <option value="<?=h($it['id'])?>"><?=h($it['name'])?> (Stock: <?=h($it['stock_qty'])?> <?=h($it['unit'])?>)</option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Qty</label>
      <input class="form-control" id="qty" type="number" min="1" value="1">
    </div>
    <div class="col-md-2">
      <button type="button" class="btn btn-outline-primary w-100" onclick="addLine()">Add</button>
    </div>
  </div>

  <hr>
  <div class="table-responsive">
    <table class="table" id="linesTable">
      <thead><tr><th>Item</th><th style="width:140px;">Qty</th><th style="width:90px;"></th></tr></thead>
      <tbody></tbody>
    </table>
  </div>

  <div class="mb-3">
    <label class="form-label">Note</label>
    <textarea class="form-control" name="note" rows="2"></textarea>
  </div>

  <div class="d-flex gap-2">
    <button class="btn btn-success" type="submit">Submit Request</button>
    <a class="btn btn-secondary" href="<?=h(base_url('requester/my_requests.php'))?>">Cancel</a>
  </div>

  <div id="linesInputs"></div>
</form>

<script>
const itemsMap = new Map();
<?php foreach ($items as $it): ?>
itemsMap.set("<?=h($it['id'])?>", "<?=h(addslashes($it['name']))?>");
<?php endforeach; ?>

function addLine() {
  const itemId = document.getElementById('item_id').value;
  const qty = parseInt(document.getElementById('qty').value || '0', 10);
  if (!itemId || qty < 1) return;

  const existing = document.querySelector(`#linesTable tbody tr[data-item-id="${itemId}"]`);
  if (existing) {
    const qInput = existing.querySelector('input.line-qty');
    qInput.value = parseInt(qInput.value, 10) + qty;
    syncHiddenInputs();
    return;
  }

  const tr = document.createElement('tr');
  tr.dataset.itemId = itemId;
  tr.innerHTML = `
    <td>${itemsMap.get(itemId) || itemId}</td>
    <td><input type="number" min="1" class="form-control line-qty" value="${qty}" onchange="syncHiddenInputs()"></td>
    <td><button type="button" class="btn btn-sm btn-outline-danger" onclick="removeLine('${itemId}')">Remove</button></td>
  `;
  document.querySelector('#linesTable tbody').appendChild(tr);
  syncHiddenInputs();
}

function removeLine(itemId) {
  const tr = document.querySelector(`#linesTable tbody tr[data-item-id="${itemId}"]`);
  if (tr) tr.remove();
  syncHiddenInputs();
}

function syncHiddenInputs() {
  const container = document.getElementById('linesInputs');
  container.innerHTML = '';
  const rows = document.querySelectorAll('#linesTable tbody tr');
  let i = 0;
  rows.forEach(r => {
    const itemId = r.dataset.itemId;
    const qty = r.querySelector('input.line-qty').value;
    container.insertAdjacentHTML('beforeend', `
      <input type="hidden" name="lines[${i}][item_id]" value="${itemId}">
      <input type="hidden" name="lines[${i}][qty]" value="${qty}">
    `);
    i++;
  });
}
</script>

<?php include __DIR__ . '/../partials/footer.php'; ?>
