<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['REQUESTER']);

$pdo = db();

function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?");
  $st->execute([$name]);
  return (bool)$st->fetchColumn();
}

$hasCategories = table_exists($pdo, 'categories');

if ($hasCategories) {
  $items = $pdo->query("
    SELECT i.id, i.name, i.unit, i.stock_qty, c.name AS category_name
    FROM items i
    LEFT JOIN categories c ON c.id = i.category_id
    WHERE i.is_active=1
    ORDER BY c.name, i.name
  ")->fetchAll();
} else {
  $items = $pdo->query("
    SELECT id, name, unit, stock_qty
    FROM items
    WHERE is_active=1
    ORDER BY name
  ")->fetchAll();
}

include __DIR__ . '/../partials/header.php';
?>

<h3 class="mb-3">New Request</h3>

<form method="post" action="<?=h(base_url('requester/actions/submit_request.php'))?>" class="card shadow-sm">
  <div class="card-body">

    <div class="row g-2 align-items-end">
      <div class="col-md-7">
        <label class="form-label fw-semibold">Search item</label>

        <!-- Searchable select (autocomplete) with grouped categories -->
<select class="form-select" id="item_select" placeholder="Type to search...">
  <option value="">Type to search…</option>
  <?php
    $currentCat = null;
    foreach ($items as $it):
      $cat = $it['category_name'] ?? '';
      $cat = trim((string)$cat);
      if ($hasCategories) {
        if ($cat === '') $cat = 'Uncategorized';
        if ($currentCat !== $cat) {
          if ($currentCat !== null) echo "</optgroup>";
          echo "<optgroup label=\"".h($cat)."\">";
          $currentCat = $cat;
        }
      }
      $label = ($hasCategories ? '' : '') . $it['name'] . " (Stock: " . $it['stock_qty'] . " " . $it['unit'] . ")";
      $display = ($hasCategories ? (($it['category_name'] ? ($it['category_name'].' — ') : '') ) : '') . $it['name'] . " (" . $it['unit'] . ")";
  ?>
      <option value="<?=h($it['id'])?>" data-display="<?=h($display)?>">
        <?=h($label)?>
      </option>
  <?php endforeach;
    if ($hasCategories && $currentCat !== null) echo "</optgroup>";
  ?>
</select>

<input type="hidden" id="item_id" value="">
        <div class="form-text">Start typing and pick from the dropdown suggestions.</div>
      </div>

      <div class="col-md-3">
        <label class="form-label fw-semibold">Qty</label>
        <input class="form-control" id="qty" type="number" min="1" value="1">
      </div>

      <div class="col-md-2">
        <button type="button" class="btn btn-outline-primary w-100" onclick="addLine()">Add</button>
      </div>
    </div>

    <hr class="my-4">

    <div class="table-responsive">
      <table class="table table-hover align-middle" id="linesTable">
        <thead class="table-light">
          <tr>
            <th>Item</th>
            <th style="width:140px;">Qty</th>
            <th style="width:110px;"></th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>

    <div class="mb-3">
      <label class="form-label fw-semibold">Note</label>
      <textarea class="form-control" name="note" rows="2" placeholder="Optional note..."></textarea>
    </div>

    <div class="d-flex gap-2">
      <button class="btn btn-success" type="submit">Submit Request</button>
      <a class="btn btn-outline-secondary" href="<?=h(base_url('requester/my_requests.php'))?>">Cancel</a>
    </div>

    <div id="linesInputs"></div>
  </div>
</form>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.bootstrap5.min.css">
<script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js"></script>

<script>
// Tom Select grouped autocomplete
const itemSelectEl = document.getElementById('item_select');
const hiddenItemId = document.getElementById('item_id');

// Build display map from option data-display
const idToDisplay = new Map();
Array.from(itemSelectEl.options).forEach(opt => {
  if (!opt.value) return;
  idToDisplay.set(opt.value, opt.getAttribute('data-display') || opt.textContent.trim());
});

// Init Tom Select (search + autocomplete) with optgroups
const ts = new TomSelect(itemSelectEl, {
  placeholder: 'Type to search…',
  allowEmptyOption: true,
  maxOptions: 200,
  searchField: ['text'],
  render: {
    optgroup_header: function(data, escape) {
      // Category label in bold
      return '<div class="optgroup-header fw-bold text-uppercase small px-2 py-1 bg-light border-bottom">' + escape(data.label) + '</div>';
    }
  }
});

function syncSelectedId() {
  const val = ts.getValue();
  hiddenItemId.value = val ? val : '';
}
itemSelectEl.addEventListener('change', syncSelectedId);

function addLine() {
  syncSelectedId();

  const itemId = hiddenItemId.value;
  const qty = parseInt(document.getElementById('qty').value || '0', 10);

  if (!itemId) {
    alert('Please choose an item from the dropdown suggestions.');
    return;
  }
  if (qty < 1) return;

  const existing = document.querySelector(`#linesTable tbody tr[data-item-id="${itemId}"]`);
  if (existing) {
    const qInput = existing.querySelector('input.line-qty');
    qInput.value = parseInt(qInput.value, 10) + qty;
    syncHiddenInputs();
    return;
  }

  const tr = document.createElement('tr');
  tr.dataset.itemId = itemId;
  tr.innerHTML = `
    <td class="fw-semibold">${idToDisplay.get(itemId) || itemId}</td>
    <td><input type="number" min="1" class="form-control line-qty" value="${qty}" onchange="syncHiddenInputs()"></td>
    <td><button type="button" class="btn btn-sm btn-outline-danger" onclick="removeLine('${itemId}')">Remove</button></td>
  `;

  document.querySelector('#linesTable tbody').appendChild(tr);

  // UX: reset selection for next item
  ts.clear();
  hiddenItemId.value = '';
  document.getElementById('qty').value = 1;

  syncHiddenInputs();
}

function removeLine(itemId) {
  const tr = document.querySelector(`#linesTable tbody tr[data-item-id="${itemId}"]`);
  if (tr) tr.remove();
  syncHiddenInputs();
}

function syncHiddenInputs() {
  const container = document.getElementById('linesInputs');
  container.innerHTML = '';
  const rows = document.querySelectorAll('#linesTable tbody tr');
  let i = 0;
  rows.forEach(r => {
    const itemId = r.dataset.itemId;
    const qty = r.querySelector('input.line-qty').value;
    container.insertAdjacentHTML('beforeend', `
      <input type="hidden" name="lines[${i}][item_id]" value="${itemId}">
      <input type="hidden" name="lines[${i}][qty]" value="${qty}">
    `);
    i++;
  });
}
</script>

<?php include __DIR__ . '/../partials/footer.php'; ?>
