<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['REQUESTER']);
$u = current_user();

$id = (int)($_GET['id'] ?? 0);
$stmt = db()->prepare("
  SELECT r.*, sk.full_name AS storekeeper_name
  FROM requests r
  LEFT JOIN users sk ON sk.id = r.assigned_to_id
  WHERE r.id = ? AND r.requester_id = ?
");
$stmt->execute([$id, $u['id']]);
$r = $stmt->fetch();
if (!$r) { http_response_code(404); echo "Not found"; exit; }

$lines = db()->prepare("
  SELECT rl.*, i.name, i.unit
  FROM request_lines rl
  JOIN items i ON i.id = rl.item_id
  WHERE rl.request_id = ?
");
$lines->execute([$id]);
$lines = $lines->fetchAll();

include __DIR__ . '/../partials/header.php';
?>
<div class="d-flex justify-content-between align-items-center">
  <h3>Request #<?=h($r['id'])?></h3>
  <a class="btn btn-secondary" href="<?=h(base_url('requester/my_requests.php'))?>">Back</a>
</div>

<div class="card card-body mt-3">
  <div class="row">
    <div class="col-md-4"><strong>Status:</strong> <?=h($r['status'])?></div>
    <div class="col-md-4"><strong>Assigned to:</strong> <?=h($r['storekeeper_name'] ?? '-')?></div>
    <div class="col-md-4"><strong>Created:</strong> <?=h($r['created_at'])?></div>
  </div>
  <?php if ($r['note']): ?>
    <hr><div><strong>Note:</strong> <?=h($r['note'])?></div>
  <?php endif; ?>
</div>

<div class="card card-body mt-3">
  <h5>Items</h5>
  <table class="table">
    <thead><tr><th>Item</th><th>Requested</th><th>Delivered</th></tr></thead>
    <tbody>
      <?php foreach ($lines as $ln): ?>
        <tr>
          <td><?=h($ln['name'])?></td>
          <td><?=h($ln['qty_requested'])?> <?=h($ln['unit'])?></td>
          <td><?=h($ln['qty_delivered'])?> <?=h($ln['unit'])?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <?php if ($r['status'] === 'DELIVERED'): ?>
    <form method="post" action="<?=h(base_url('requester/actions/confirm_received.php'))?>" onsubmit="return confirm('Confirm you received the items?')">
      <input type="hidden" name="id" value="<?=h($r['id'])?>">
      <button class="btn btn-success">Confirm Received</button>
    </form>
  <?php endif; ?>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
