<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_once __DIR__ . '/../../lib/mailer.php';
require_role(['STOREKEEPER']);
$u = current_user();

$id = (int)($_POST['id'] ?? 0);
$pdo = db();
$pdo->beginTransaction();
try {
  $stmt = $pdo->prepare("
    SELECT r.*, req.email AS requester_email, req.full_name AS requester_name
    FROM requests r
    JOIN users req ON req.id = r.requester_id
    WHERE r.id=? AND r.assigned_to_id=?
    FOR UPDATE
  ");
  $stmt->execute([$id, $u['id']]);
  $r = $stmt->fetch();
  if (!$r) throw new Exception("Request not found.");
  if ($r['status'] !== 'SUBMITTED') throw new Exception("Request must be SUBMITTED.");

  $pdo->prepare("UPDATE requests SET status='PREPARING', prepared_at=NOW(), updated_at=NOW() WHERE id=?")->execute([$id]);
  $pdo->commit();

  if (!empty($r['requester_email'])) {
    send_email($r['requester_email'], "Request #{$id} is being prepared", "<p>Hello ".h($r['requester_name']).",</p><p>Your request #{$id} is being prepared.</p>");
  }

  flash_set('success', 'Marked as PREPARING.');
  header('Location: ' . base_url('storekeeper/request_view.php?id=' . $id));
  exit;
} catch (Throwable $e) {
  $pdo->rollBack();
  flash_set('danger', 'Error: ' . $e->getMessage());
  header('Location: ' . base_url('storekeeper/request_view.php?id=' . $id));
  exit;
}
