<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_once __DIR__ . '/../../lib/notifications.php';
require_role(['STOREKEEPER','ADMIN']);

$u = current_user();
$id = (int)($_POST['id'] ?? 0);
$pdo = db();

if ($id <= 0) {
  flash_set('danger', 'Invalid request id.');
  header('Location: ' . base_url('storekeeper/inbox.php'));
  exit;
}

$pdo->beginTransaction();
try {
  $stmt = $pdo->prepare("
    SELECT r.*, req.email AS requester_email, req.full_name AS requester_name
    FROM requests r
    JOIN users req ON req.id = r.requester_id
    WHERE r.id=?
    FOR UPDATE
  ");
  $stmt->execute([$id]);
  $r = $stmt->fetch();
  if (!$r) throw new Exception("Request not found.");

  $status = strtoupper((string)$r['status']);
  if ($status !== 'SUBMITTED') {
    throw new Exception("Request must be SUBMITTED to deliver.");
  }

  $linesSt = $pdo->prepare("
    SELECT rl.id AS line_id, rl.item_id, rl.qty_requested, rl.qty_delivered, i.stock_qty
    FROM request_lines rl
    JOIN items i ON i.id = rl.item_id
    WHERE rl.request_id=?
    FOR UPDATE
  ");
  $linesSt->execute([$id]);
  $lines = $linesSt->fetchAll();
  if (!$lines) throw new Exception("No items found for this request.");

  // Validate quantities
  foreach ($lines as $ln) {
    $reqQty = (int)$ln['qty_requested'];
    $delQty = (int)$ln['qty_delivered'];
    if ($delQty < 0) $delQty = 0;
    if ($delQty > $reqQty) throw new Exception("Delivered qty cannot exceed requested (line {$ln['line_id']}).");
    if ($delQty > (int)$ln['stock_qty']) throw new Exception("Not enough stock for item_id {$ln['item_id']}.");
  }

  // Deduct stock and record moves
  $updItem = $pdo->prepare("UPDATE items SET stock_qty = stock_qty - ? WHERE id=?");
  $insMove = $pdo->prepare("
    INSERT INTO stock_moves(item_id, move_type, ref_table, ref_id, qty, created_by, note)
    VALUES(?, 'ISSUE_OUT','requests', ?, ?, ?, ?)
  ");

  foreach ($lines as $ln) {
    $delQty = (int)$ln['qty_delivered'];
    if ($delQty <= 0) continue;
    $updItem->execute([$delQty, (int)$ln['item_id']]);
    $insMove->execute([(int)$ln['item_id'], $id, -$delQty, (int)$u['id'], "Issued for request #{$id}"]);
  }

  // Mark request delivered
  $pdo->prepare("
    UPDATE requests
    SET status='DELIVERED', delivered_at=NOW(), updated_at=NOW()
    WHERE id=?
  ")->execute([$id]);

  $pdo->commit();

  // Email requester after commit
  notify_requester_delivered($id);

  flash_set('success', 'Marked as DELIVERED. Stock deducted and email sent.');
  header('Location: ' . base_url('storekeeper/request_view.php?id=' . $id));
  exit;

} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  flash_set('danger', 'Error: ' . $e->getMessage());
  header('Location: ' . base_url('storekeeper/request_view.php?id=' . $id));
  exit;
}
