<?php
require_once __DIR__ . '/../../lib/bootstrap.php';
require_role(['STOREKEEPER','ADMIN']);

$pdo = db();
$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) {
  flash_set('danger', 'Invalid request id.');
  header('Location: ' . base_url('storekeeper/inbox.php'));
  exit;
}

$delivered = $_POST['delivered'] ?? null;
if (!is_array($delivered)) {
  $delivered = [];
  $lines = $_POST['lines'] ?? [];
  if (is_array($lines)) {
    foreach ($lines as $line_id => $ln) {
      if (is_array($ln) && isset($ln['qty_delivered'])) {
        $delivered[(int)$line_id] = $ln['qty_delivered'];
      }
    }
  }
}

try {
  $pdo->beginTransaction();

  $req = $pdo->prepare("SELECT id, status FROM requests WHERE id=? FOR UPDATE");
  $req->execute([$id]);
  $r = $req->fetch();
  if (!$r) throw new Exception('Request not found.');

  $status = strtoupper((string)$r['status']);
  if ($status !== 'SUBMITTED') {
    throw new Exception('You can only edit delivered quantities while SUBMITTED.');
  }

  $st = $pdo->prepare("
    SELECT rl.id AS line_id, rl.qty_requested
    FROM request_lines rl
    WHERE rl.request_id=?
    FOR UPDATE
  ");
  $st->execute([$id]);
  $lines = $st->fetchAll();
  if (!$lines) throw new Exception('No lines found for this request.');

  $upd = $pdo->prepare("UPDATE request_lines SET qty_delivered=? WHERE id=? AND request_id=?");
  $updatedCount = 0;

  foreach ($lines as $ln) {
    $lineId = (int)$ln['line_id'];
    $reqQty = (int)$ln['qty_requested'];
    $val = $delivered[$lineId] ?? null;
    if ($val === null || $val === '') continue;

    $q = (int)$val;
    if ($q < 0) $q = 0;
    if ($q > $reqQty) $q = $reqQty;
    $upd->execute([$q, $lineId, $id]);
    $updatedCount++;
  }

  $pdo->prepare("UPDATE requests SET updated_at=NOW() WHERE id=?")->execute([$id]);
  $pdo->commit();

  flash_set('success', "Saved delivered quantities ({$updatedCount} line(s)).");
  header('Location: ' . base_url('storekeeper/request_view.php?id=' . $id));
  exit;

} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  flash_set('danger', 'Error: ' . $e->getMessage());
  header('Location: ' . base_url('storekeeper/request_view.php?id=' . $id));
  exit;
}
