<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['STOREKEEPER','ADMIN']);

$pdo = db();

function q($k,$d=null){ return $_GET[$k] ?? $d; }
function clamp_int($v,$min,$max,$d){
  if($v===null || $v==='') return $d;
  $v=(int)$v;
  if($v<$min) return $min;
  if($v>$max) return $max;
  return $v;
}
function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?"); $st->execute([$name]); return (bool)$st->fetchColumn();
}
function col_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?"); $st->execute([$col]); return (bool)$st->fetchColumn();
}

// Threshold column compatibility: support threshold or threshold_qty
$thCol = null;
if (col_exists($pdo,'items','threshold')) $thCol = 'threshold';
elseif (col_exists($pdo,'items','threshold_qty')) $thCol = 'threshold_qty';

if (!$thCol) {
  $page_title="Stock Alerts";
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-warning shadow-sm">Column <code>items.threshold</code> (or <code>threshold_qty</code>) not found. Please add it.</div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}


$search = trim((string)q('search',''));
$category_id = (int)q('category_id', 0);
$page = clamp_int(q('page'), 1, 1000000, 1);
$per_page = clamp_int(q('per_page'), 5, 200, 25);
$offset = ($page-1)*$per_page;

$hasCategories = table_exists($pdo,'categories') && col_exists($pdo,'items','category_id');
$cats = [];
if ($hasCategories) {
  $cats = $pdo->query("SELECT id, name FROM categories ORDER BY name")->fetchAll();
}

$where = ["COALESCE(i.$thCol,0) > 0", "i.stock_qty <= COALESCE(i.$thCol,0)"];
$params = [];

if ($hasCategories && $category_id > 0) { $where[] = "i.category_id=?"; $params[] = $category_id; }
if ($search !== '') { $where[] = "(i.name LIKE ? OR i.unit LIKE ?)"; $like="%{$search}%"; $params[]=$like; $params[]=$like; }

$whereSql = "WHERE " . implode(" AND ", $where);

// Count items in alert list
$count = $pdo->prepare("SELECT COUNT(*) FROM items i $whereSql");
$count->execute($params);
$total = (int)$count->fetchColumn();
$total_pages = max(1, (int)ceil($total/$per_page));
if ($page > $total_pages) { $page=$total_pages; $offset=($page-1)*$per_page; }

$sql = "
  SELECT i.id, i.name, i.unit, i.stock_qty, COALESCE(i.$thCol,0) AS threshold
  ".($hasCategories ? ", c.name AS category_name" : "")."
  FROM items i
  ".($hasCategories ? "LEFT JOIN categories c ON c.id=i.category_id" : "")."
  $whereSql
  ORDER BY (i.stock_qty=0) DESC, i.stock_qty ASC, i.name ASC
  LIMIT $per_page OFFSET $offset
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

// Summary cards across ALL items
$sum = $pdo->query("SELECT
  SUM(CASE WHEN stock_qty=0 THEN 1 ELSE 0 END) AS critical,
  SUM(CASE WHEN stock_qty>0 AND stock_qty<=COALESCE($thCol,0) AND COALESCE($thCol,0)>0 THEN 1 ELSE 0 END) AS low
  FROM items")->fetch();
$critical = (int)($sum['critical'] ?? 0);
$low = (int)($sum['low'] ?? 0);

function qs_keep($overrides=[]){
  $b=$_GET;
  foreach($overrides as $k=>$v){ $b[$k]=$v; }
  return http_build_query($b);
}

$page_title="Stock Alerts";
include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Stock Alerts</h3>
    <div class="text-muted">Items at or below threshold</div>
  </div>
</div>

<div class="row g-3 mb-3">
  <div class="col-md-3"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted small">Critical (0 stock)</div>
    <div class="fs-3 fw-bold text-danger"><?=h($critical)?></div>
  </div></div></div>
  <div class="col-md-3"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted small">Low (<= threshold)</div>
    <div class="fs-3 fw-bold text-warning"><?=h($low)?></div>
  </div></div></div>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <?php if ($hasCategories): ?>
      <div class="col-md-3">
        <label class="form-label">Category</label>
        <select class="form-select" name="category_id">
          <option value="0">All</option>
          <?php foreach($cats as $c): ?>
            <option value="<?=h((int)$c['id'])?>" <?=($category_id===(int)$c['id']?'selected':'')?>><?=h($c['name'])?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <?php endif; ?>

      <div class="col-md-4">
        <label class="form-label">Search</label>
        <input class="form-control" name="search" value="<?=h($search)?>" placeholder="Item name or unit…">
      </div>

      <div class="col-md-2">
        <label class="form-label">Rows per page</label>
        <select class="form-select" name="per_page">
          <?php foreach([10,25,50,100,200] as $n): ?>
            <option value="<?=h($n)?>" <?=($per_page===$n?'selected':'')?>><?=h($n)?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-2"><button class="btn btn-primary w-100"><i class="bi bi-funnel me-1"></i>Apply</button></div>
      <div class="col-md-2"><a class="btn btn-outline-secondary w-100" href="<?=h(base_url('storekeeper/alerts.php'))?>">Reset</a></div>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <div class="p-3 border-bottom d-flex justify-content-between align-items-center">
      <div class="text-muted small"><?=h($total)?> item(s) • Page <?=h($page)?> / <?=h($total_pages)?></div>
      <nav><ul class="pagination pagination-sm mb-0">
        <li class="page-item <?=($page<=1?'disabled':'')?>"><a class="page-link" href="?<?=h(qs_keep(['page'=>max(1,$page-1)]))?>">Prev</a></li>
        <li class="page-item disabled"><span class="page-link"><?=h($page)?></span></li>
        <li class="page-item <?=($page>=$total_pages?'disabled':'')?>"><a class="page-link" href="?<?=h(qs_keep(['page'=>min($total_pages,$page+1)]))?>">Next</a></li>
      </ul></nav>
    </div>

    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Item</th>
            <?php if ($hasCategories): ?><th>Category</th><?php endif; ?>
            <th class="text-end" style="width:120px;">Stock</th>
            <th class="text-end" style="width:140px;">Threshold</th>
            <th style="width:120px;">Status</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows): ?>
            <tr><td colspan="<?=h($hasCategories?5:4)?>" class="p-4 text-center text-muted">No alerts.</td></tr>
          <?php endif; ?>
          <?php foreach($rows as $r): ?>
            <?php
              $status='LOW';
              $badge='bg-warning text-dark';
              if ((int)$r['stock_qty']<=0){ $status='CRITICAL'; $badge='bg-danger'; }
            ?>
            <tr>
              <td class="fw-semibold"><?=h($r['name'])?> <span class="text-muted small">(<?=h($r['unit'])?>)</span></td>
              <?php if ($hasCategories): ?><td class="text-muted"><?=h($r['category_name'] ?? '—')?></td><?php endif; ?>
              <td class="text-end fw-semibold"><?=h((int)$r['stock_qty'])?></td>
              <td class="text-end"><?=h((int)$r['threshold'])?></td>
              <td><span class="badge <?=h($badge)?>"><?=h($status)?></span></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
