<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['STOREKEEPER','ADMIN']);

$pdo = db();
function q($k,$d=null){ return $_GET[$k] ?? $d; }
function clamp_int($v,$min,$max,$d){
  if($v===null || $v==='') return $d;
  $v=(int)$v;
  if($v<$min) return $min;
  if($v>$max) return $max;
  return $v;
}

$search = trim((string)q('search',''));
$status = strtoupper(trim((string)q('status','')));
$page = clamp_int(q('page'), 1, 1000000, 1);
$per_page = clamp_int(q('per_page'), 5, 200, 25);
$offset = ($page-1)*$per_page;

$where = [];
$params = [];

if ($status !== '' && in_array($status, ['SUBMITTED','DELIVERED'], true)) {
  $where[] = "r.status = ?";
  $params[] = $status;
}
if ($search !== '') {
  $where[] = "(CAST(r.id AS CHAR) LIKE ? OR req.full_name LIKE ? OR req.email LIKE ?)";
  $like = "%{$search}%";
  $params[] = $like; $params[] = $like; $params[] = $like;
}
$whereSql = $where ? ("WHERE ".implode(" AND ", $where)) : "";

$count = $pdo->prepare("
  SELECT COUNT(*)
  FROM requests r
  JOIN users req ON req.id = r.requester_id
  $whereSql
");
$count->execute($params);
$total = (int)$count->fetchColumn();
$total_pages = max(1, (int)ceil($total/$per_page));
if ($page > $total_pages) { $page = $total_pages; $offset = ($page-1)*$per_page; }

$sql = "
  SELECT r.id, r.status, r.created_at,
         req.full_name AS requester_name,
         (SELECT COUNT(*) FROM request_lines rl WHERE rl.request_id=r.id) AS items_count
  FROM requests r
  JOIN users req ON req.id = r.requester_id
  $whereSql
  ORDER BY r.id DESC
  LIMIT $per_page OFFSET $offset
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

function qs_keep(array $overrides=[]): string {
  $b = $_GET;
  foreach($overrides as $k=>$v){ $b[$k]=$v; }
  return http_build_query($b);
}

$page_title = "Inbox";
include __DIR__ . '/../partials/header.php';
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">All Requests</h3>
    <div class="text-muted">Showing <?=h($total)?> request(s)</div>
  </div>
</div>

<form class="card shadow-sm mb-3" method="get">
  <div class="card-body">
    <div class="row g-2 align-items-end">
      <div class="col-md-5">
        <label class="form-label">Search</label>
        <input class="form-control" name="search" value="<?=h($search)?>" placeholder="Request #, requester name, email...">
      </div>
      <div class="col-md-3">
        <label class="form-label">Status</label>
        <select class="form-select" name="status">
          <option value="">All</option>
          <?php foreach(['SUBMITTED','DELIVERED'] as $s): ?>
            <option value="<?=h($s)?>" <?=($status===$s?'selected':'')?>><?=h($s)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Rows</label>
        <select class="form-select" name="per_page">
          <?php foreach([10,25,50,100] as $n): ?>
            <option value="<?=h($n)?>" <?=($per_page===$n?'selected':'')?>><?=h($n)?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2"><button class="btn btn-primary w-100"><i class="bi bi-funnel me-1"></i>Apply</button></div>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <div class="p-3 border-bottom d-flex justify-content-between align-items-center">
      <div class="text-muted small">Page <?=h($page)?> / <?=h($total_pages)?></div>
      <nav><ul class="pagination pagination-sm mb-0">
        <li class="page-item <?=($page<=1?'disabled':'')?>"><a class="page-link" href="?<?=h(qs_keep(['page'=>max(1,$page-1)]))?>">Prev</a></li>
        <li class="page-item disabled"><span class="page-link"><?=h($page)?></span></li>
        <li class="page-item <?=($page>=$total_pages?'disabled':'')?>"><a class="page-link" href="?<?=h(qs_keep(['page'=>min($total_pages,$page+1)]))?>">Next</a></li>
      </ul></nav>
    </div>

    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th style="width:90px;">#</th>
            <th>Requester</th>
            <th style="width:140px;">Status</th>
            <th style="width:120px;" class="text-end">Items</th>
            <th style="width:180px;">Created</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows): ?>
            <tr><td colspan="5" class="p-4 text-center text-muted">No requests found.</td></tr>
          <?php endif; ?>
          <?php foreach($rows as $r): ?>
            <?php
              $stt = strtoupper((string)$r['status']);
              $badge = ($stt==='DELIVERED') ? 'bg-success' : 'bg-danger';
            ?>
            <tr>
              <td class="fw-semibold">
                <a href="<?=h(base_url('storekeeper/request_view.php?id='.(int)$r['id']))?>">#<?=h((int)$r['id'])?></a>
              </td>
              <td><?=h($r['requester_name'])?></td>
              <td><span class="badge <?=h($badge)?>"><?=h($stt)?></span></td>
              <td class="text-end"><?=h((int)$r['items_count'])?></td>
              <td class="text-muted small"><?=h($r['created_at'])?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
