<?php
require_once __DIR__ . '/../lib/bootstrap.php';
require_role(['STOREKEEPER','ADMIN']);

$pdo = db();
$id = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("
  SELECT r.*, req.full_name AS requester_name, req.email AS requester_email
  FROM requests r
  JOIN users req ON req.id = r.requester_id
  WHERE r.id = ?
");
$st->execute([$id]);
$r = $st->fetch();
if (!$r) {
  http_response_code(404);
  $page_title = "Request not found";
  include __DIR__ . '/../partials/header.php';
  echo '<div class="alert alert-danger shadow-sm">Request not found.</div>';
  include __DIR__ . '/../partials/footer.php';
  exit;
}

$linesSt = $pdo->prepare("
  SELECT rl.id AS line_id, rl.item_id, rl.qty_requested, rl.qty_delivered,
         i.name AS item_name, i.unit, i.stock_qty
  FROM request_lines rl
  JOIN items i ON i.id = rl.item_id
  WHERE rl.request_id = ?
  ORDER BY i.name
");
$linesSt->execute([$id]);
$lines = $linesSt->fetchAll();

$page_title = "Request #{$id}";
include __DIR__ . '/../partials/header.php';

$status = strtoupper((string)$r['status']);
// Simple workflow: SUBMITTED -> DELIVERED (no preparing)
$canEdit = ($status === 'SUBMITTED');
$canDeliver = ($status === 'SUBMITTED');
?>

<div class="d-flex justify-content-between align-items-start mb-3">
  <div>
    <h3 class="mb-1">Request #<?=h($id)?></h3>
    <div class="text-muted">
      Requester: <strong><?=h($r['requester_name'])?></strong>
      <span class="mx-2">•</span>
      Status:
      <?php
        $badge='bg-secondary';
        if ($status==='SUBMITTED') $badge='bg-danger';
        elseif ($status==='DELIVERED') $badge='bg-success';
      ?>
      <span class="badge <?=h($badge)?>"><?=h($status)?></span>
    </div>
  </div>
  <a class="btn btn-outline-secondary" href="<?=h(base_url('storekeeper/inbox.php'))?>">
    <i class="bi bi-arrow-left me-1"></i>Back
  </a>
</div>

<?php if ($canEdit): ?>
<div class="card shadow-sm mb-3">
  <div class="card-body d-flex flex-wrap gap-2 justify-content-between align-items-center">
    <div class="text-muted small">
      Enter delivered quantities, then click <strong>Save</strong>. Use <strong>Deliver all</strong> to auto-fill.
    </div>
    <div class="d-flex gap-2">
      <button type="button" class="btn btn-outline-primary btn-sm" id="btnDeliverAll">
        <i class="bi bi-check2-square me-1"></i>Deliver all (Requested)
      </button>
      <button type="button" class="btn btn-outline-secondary btn-sm" id="btnZeroAll">
        <i class="bi bi-x-square me-1"></i>Clear delivered
      </button>
    </div>
  </div>
</div>
<?php endif; ?>

<form method="post" action="<?=h(base_url('storekeeper/actions/update_lines.php'))?>" class="card shadow-sm mb-3">
  <input type="hidden" name="id" value="<?=h((int)$id)?>">

  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Item</th>
            <th style="width:120px;" class="text-end">Requested</th>
            <th style="width:170px;" class="text-end">Delivered</th>
            <th style="width:120px;" class="text-end">In Stock</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($lines as $ln): ?>
            <?php
              $reqQty = (int)$ln['qty_requested'];
              $delQty = (int)$ln['qty_delivered'];
              $stock  = (int)$ln['stock_qty'];
              $low = ($stock < $reqQty);
            ?>
            <tr>
              <td class="fw-semibold">
                <?=h($ln['item_name'])?>
                <span class="text-muted small">(<?=h($ln['unit'])?>)</span>
                <?php if ($low): ?>
                  <span class="badge bg-warning text-dark ms-2">Low stock</span>
                <?php endif; ?>
              </td>
              <td class="text-end">
                <span class="badge bg-light text-dark border"><?=h($reqQty)?></span>
              </td>
              <td class="text-end">
                <?php if ($canEdit): ?>
                  <input class="form-control form-control-sm text-end delivered-input"
                         style="max-width:130px;display:inline-block"
                         type="number" min="0" step="1"
                         name="delivered[<?=h((int)$ln['line_id'])?>]"
                         value="<?=h($delQty)?>"
                         data-requested="<?=h($reqQty)?>"
                         data-stock="<?=h($stock)?>">
                  <div class="form-text text-end mb-0">max <?=h($reqQty)?> (requested)</div>
                <?php else: ?>
                  <span class="badge bg-light text-dark border"><?=h($delQty)?></span>
                <?php endif; ?>
              </td>
              <td class="text-end text-muted"><?=h($stock)?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php if ($canEdit): ?>
  <div class="card-footer d-flex justify-content-between align-items-center">
    <div class="text-muted small">Tip: delivered cannot exceed requested.</div>
    <button class="btn btn-primary" type="submit">
      <i class="bi bi-save me-1"></i>Save
    </button>
  </div>
  <?php endif; ?>
</form>

<?php if ($canDeliver): ?>
<form method="post" action="<?=h(base_url('storekeeper/actions/mark_delivered.php'))?>" class="card shadow-sm">
  <input type="hidden" name="id" value="<?=h((int)$id)?>">
  <div class="card-body d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold">Finish Request (Deliver)</div>
      <div class="text-muted small">This will deduct stock for delivered quantities and email the requester.</div>
    </div>
    <button class="btn btn-success" type="submit">
      <i class="bi bi-truck me-1"></i>Deliver / Done
    </button>
  </div>
</form>
<?php endif; ?>

<script>
(function(){
  const inputs = Array.from(document.querySelectorAll('.delivered-input'));
  function clampInputs(){
    inputs.forEach(inp=>{
      const req = Number(inp.dataset.requested||0);
      let v = Number(inp.value||0);
      if (Number.isNaN(v)) v = 0;
      if (v < 0) v = 0;
      if (v > req) v = req;
      inp.value = String(v);
    });
  }
  inputs.forEach(inp=> inp.addEventListener('change', clampInputs));

  const btnAll = document.getElementById('btnDeliverAll');
  if (btnAll) btnAll.addEventListener('click', ()=>{
    inputs.forEach(inp=>{ inp.value = inp.dataset.requested || '0'; });
    clampInputs();
  });

  const btnZero = document.getElementById('btnZeroAll');
  if (btnZero) btnZero.addEventListener('click', ()=>{
    inputs.forEach(inp=>{ inp.value = '0'; });
  });
})();
</script>

<?php include __DIR__ . '/../partials/footer.php'; ?>
