<?php
require_once __DIR__ . '/../lib/bootstrap.php';
include __DIR__ . '/../partials/header.php';

$hash = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pw = $_POST['password'] ?? '';
  if ($pw !== '') $hash = password_hash($pw, PASSWORD_DEFAULT);
}
?>
<h3>Generate Password Hash</h3>
<form method="post" class="card card-body">
  <div class="mb-3">
    <label class="form-label">Password</label>
    <input class="form-control" name="password" type="text" required>
  </div>
  <button class="btn btn-primary">Generate</button>
</form>

<?php if ($hash): ?>
  <div class="alert alert-success mt-3">
    <div><strong>Hash:</strong></div>
    <code style="word-break:break-all;"><?=h($hash)?></code>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
